/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.alluxio.AlluxioTrinoOutputStream;
import io.trino.filesystem.alluxio.AlluxioUtils;
import io.trino.memory.context.AggregatedMemoryContext;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.util.Objects;

public class AlluxioFileSystemOutputFile
implements TrinoOutputFile {
    private final Location rootLocation;
    private final Location location;
    private final FileSystem fileSystem;
    private final String mountRoot;

    public AlluxioFileSystemOutputFile(Location rootLocation, Location location, FileSystem fileSystem, String mountRoot) {
        this.rootLocation = Objects.requireNonNull(rootLocation, "root location is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.mountRoot = Objects.requireNonNull(mountRoot, "mountRoot is null");
    }

    public void createOrOverwrite(byte[] data) throws IOException {
        this.ensureOutputFileNotOutsideOfRoot(this.location);
        try (FileOutStream outStream = this.fileSystem.createFile(AlluxioUtils.convertToAlluxioURI(this.location, this.mountRoot), CreateFilePOptions.newBuilder().setOverwrite(true).setRecursive(true).build());){
            outStream.write(data);
        }
        catch (AlluxioException e) {
            throw new IOException("Error createOrOverwrite %s".formatted(this.location), e);
        }
    }

    public OutputStream create(AggregatedMemoryContext memoryContext) throws IOException {
        this.throwIfAlreadyExists();
        try {
            return new AlluxioTrinoOutputStream(this.location, (OutputStream)this.fileSystem.createFile(AlluxioUtils.convertToAlluxioURI(this.location, this.mountRoot), CreateFilePOptions.newBuilder().setRecursive(true).build()));
        }
        catch (AlluxioException e) {
            throw new IOException("Error create %s".formatted(this.location), e);
        }
    }

    public Location location() {
        return this.location;
    }

    public String toString() {
        return this.location().toString();
    }

    private void ensureOutputFileNotOutsideOfRoot(Location location) throws IOException {
        String path = AlluxioUtils.simplifyPath(location.path());
        if (this.rootLocation != null && !path.startsWith(this.rootLocation.path())) {
            throw new IOException("Output file %s outside of root is not allowed".formatted(location));
        }
    }

    private void throwIfAlreadyExists() throws IOException {
        try {
            if (this.fileSystem.exists(AlluxioUtils.convertToAlluxioURI(this.location, this.mountRoot))) {
                throw new FileAlreadyExistsException("File %s already exists".formatted(this.location));
            }
        }
        catch (AlluxioException e) {
            throw new IOException("Error create %s".formatted(this.location), e);
        }
    }
}

