/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.models.BlobProperties;
import com.google.common.base.Preconditions;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.azure.AzureInput;
import io.trino.filesystem.azure.AzureInputStream;
import io.trino.filesystem.azure.AzureLocation;
import io.trino.filesystem.azure.AzureUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

class AzureInputFile
implements TrinoInputFile {
    private final AzureLocation location;
    private final BlobClient blobClient;
    private final int readBlockSizeBytes;
    private OptionalLong length;
    private Optional<Instant> lastModified = Optional.empty();

    public AzureInputFile(AzureLocation location, OptionalLong length, BlobClient blobClient, int readBlockSizeBytes) {
        this.location = Objects.requireNonNull(location, "location is null");
        location.location().verifyValidFileLocation();
        this.length = Objects.requireNonNull(length, "length is null");
        this.blobClient = Objects.requireNonNull(blobClient, "blobClient is null");
        Preconditions.checkArgument((readBlockSizeBytes >= 0 ? 1 : 0) != 0, (Object)"readBlockSizeBytes is negative");
        this.readBlockSizeBytes = readBlockSizeBytes;
    }

    public Location location() {
        return this.location.location();
    }

    public boolean exists() {
        return this.blobClient.exists();
    }

    public TrinoInputStream newStream() throws IOException {
        return new AzureInputStream(this.location, this.blobClient, this.readBlockSizeBytes);
    }

    public TrinoInput newInput() throws IOException {
        try {
            return new AzureInput(this.location, this.blobClient, this.length);
        }
        catch (RuntimeException e) {
            throw AzureUtils.handleAzureException(e, "opening file", this.location);
        }
    }

    public Instant lastModified() throws IOException {
        if (this.lastModified.isEmpty()) {
            this.loadProperties();
        }
        return this.lastModified.orElseThrow();
    }

    public long length() throws IOException {
        if (this.length.isEmpty()) {
            this.loadProperties();
        }
        return this.length.orElseThrow();
    }

    private void loadProperties() throws IOException {
        BlobProperties properties;
        try {
            properties = this.blobClient.getProperties();
        }
        catch (RuntimeException e) {
            throw AzureUtils.handleAzureException(e, "fetching properties for file", this.location);
        }
        if (this.length.isEmpty()) {
            this.length = OptionalLong.of(properties.getBlobSize());
        }
        if (this.lastModified.isEmpty()) {
            this.lastModified = Optional.of(properties.getLastModified().toInstant());
        }
    }
}

