/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.azure.core.exception.AzureException;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.file.datalake.models.DataLakeStorageException;
import io.trino.filesystem.TrinoFileSystemException;
import io.trino.filesystem.azure.AzureLocation;
import java.io.FileNotFoundException;
import java.io.IOException;

final class AzureUtils {
    private AzureUtils() {
    }

    public static IOException handleAzureException(RuntimeException exception, String action, AzureLocation location) throws IOException {
        if (AzureUtils.isFileNotFoundException(exception)) {
            throw AzureUtils.withCause(new FileNotFoundException(location.toString()), exception);
        }
        if (exception instanceof AzureException) {
            throw new TrinoFileSystemException("Azure service error %s file: %s".formatted(action, location), (Throwable)exception);
        }
        throw new IOException("Error %s file: %s".formatted(action, location), exception);
    }

    public static boolean isFileNotFoundException(RuntimeException exception) {
        if (exception instanceof BlobStorageException) {
            BlobStorageException blobStorageException = (BlobStorageException)((Object)exception);
            return BlobErrorCode.BLOB_NOT_FOUND.equals((Object)blobStorageException.getErrorCode());
        }
        if (exception instanceof DataLakeStorageException) {
            DataLakeStorageException dataLakeStorageException = (DataLakeStorageException)((Object)exception);
            return "PathNotFound".equals(dataLakeStorageException.getErrorCode());
        }
        return false;
    }

    private static <T extends Throwable> T withCause(T throwable, Throwable cause) {
        throwable.initCause(cause);
        return throwable;
    }
}

