/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;

public class AzureFileSystemConfig {
    private AuthType authType = AuthType.DEFAULT;
    private String endpoint = "core.windows.net";
    private DataSize readBlockSize = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize writeBlockSize = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int maxWriteConcurrency = 8;
    private DataSize maxSingleUploadSize = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private Integer maxHttpRequests = 2 * Runtime.getRuntime().availableProcessors();
    private String applicationId = "Trino";

    @NotNull
    public AuthType getAuthType() {
        return this.authType;
    }

    @Config(value="azure.auth-type")
    public AzureFileSystemConfig setAuthType(AuthType authType) {
        this.authType = authType;
        return this;
    }

    @NotEmpty
    public String getEndpoint() {
        return this.endpoint;
    }

    @Config(value="azure.endpoint")
    public AzureFileSystemConfig setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @NotNull
    public DataSize getReadBlockSize() {
        return this.readBlockSize;
    }

    @Config(value="azure.read-block-size")
    public AzureFileSystemConfig setReadBlockSize(DataSize readBlockSize) {
        this.readBlockSize = readBlockSize;
        return this;
    }

    @NotNull
    public DataSize getWriteBlockSize() {
        return this.writeBlockSize;
    }

    @Config(value="azure.write-block-size")
    public AzureFileSystemConfig setWriteBlockSize(DataSize writeBlockSize) {
        this.writeBlockSize = writeBlockSize;
        return this;
    }

    public int getMaxWriteConcurrency() {
        return this.maxWriteConcurrency;
    }

    @Config(value="azure.max-write-concurrency")
    public AzureFileSystemConfig setMaxWriteConcurrency(int maxWriteConcurrency) {
        this.maxWriteConcurrency = maxWriteConcurrency;
        return this;
    }

    @NotNull
    public DataSize getMaxSingleUploadSize() {
        return this.maxSingleUploadSize;
    }

    @Config(value="azure.max-single-upload-size")
    public AzureFileSystemConfig setMaxSingleUploadSize(DataSize maxSingleUploadSize) {
        this.maxSingleUploadSize = maxSingleUploadSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxHttpRequests() {
        return this.maxHttpRequests;
    }

    @Config(value="azure.max-http-requests")
    @ConfigDescription(value="Maximum number of concurrent HTTP requests to Azure on every node")
    public AzureFileSystemConfig setMaxHttpRequests(int maxHttpRequests) {
        this.maxHttpRequests = maxHttpRequests;
        return this;
    }

    @Size(max=50)
    @NotNull
    public @Size(max=50) @NotNull String getApplicationId() {
        return this.applicationId;
    }

    @Config(value="azure.application-id")
    @ConfigDescription(value="Suffix that will be added to HTTP User-Agent header to identify the application")
    public AzureFileSystemConfig setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public static enum AuthType {
        ACCESS_KEY,
        OAUTH,
        DEFAULT;

    }
}

