/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.storage.blob.BlobContainerClientBuilder;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import com.google.inject.Inject;
import io.trino.filesystem.azure.AzureAuth;
import io.trino.filesystem.azure.AzureAuthManagedIdentityConfig;

public final class AzureAuthDefault
implements AzureAuth {
    private final TokenCredential credential;

    @Inject
    public AzureAuthDefault(AzureAuthManagedIdentityConfig config) {
        DefaultAzureCredentialBuilder builder = new DefaultAzureCredentialBuilder();
        config.getClientId().ifPresent(arg_0 -> ((DefaultAzureCredentialBuilder)builder).managedIdentityClientId(arg_0));
        config.getResourceId().ifPresent(arg_0 -> ((DefaultAzureCredentialBuilder)builder).managedIdentityResourceId(arg_0));
        this.credential = builder.build();
    }

    @Override
    public void setAuth(String storageAccount, BlobContainerClientBuilder builder) {
        builder.credential(this.credential);
    }

    @Override
    public void setAuth(String storageAccount, DataLakeServiceClientBuilder builder) {
        builder.credential(this.credential);
    }
}

