/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.azure.core.http.HttpClient;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.core.tracing.opentelemetry.OpenTelemetryTracingOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.core.util.TracingOptions;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.azure.AzureAuth;
import io.trino.filesystem.azure.AzureFileSystem;
import io.trino.filesystem.azure.AzureFileSystemConfig;
import io.trino.spi.security.ConnectorIdentity;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import reactor.netty.resources.ConnectionProvider;

public class AzureFileSystemFactory
implements TrinoFileSystemFactory {
    private final AzureAuth auth;
    private final String endpoint;
    private final DataSize readBlockSize;
    private final DataSize writeBlockSize;
    private final int maxWriteConcurrency;
    private final DataSize maxSingleUploadSize;
    private final TracingOptions tracingOptions;
    private final HttpClient httpClient;
    private final ConnectionProvider connectionProvider;
    private final EventLoopGroup eventLoopGroup;

    @Inject
    public AzureFileSystemFactory(OpenTelemetry openTelemetry, AzureAuth azureAuth, AzureFileSystemConfig config) {
        this(openTelemetry, azureAuth, config.getEndpoint(), config.getReadBlockSize(), config.getWriteBlockSize(), config.getMaxWriteConcurrency(), config.getMaxSingleUploadSize(), config.getMaxHttpRequests(), config.getApplicationId());
    }

    public AzureFileSystemFactory(OpenTelemetry openTelemetry, AzureAuth azureAuth, String endpoint, DataSize readBlockSize, DataSize writeBlockSize, int maxWriteConcurrency, DataSize maxSingleUploadSize, int maxHttpRequests, String applicationId) {
        this.auth = Objects.requireNonNull(azureAuth, "azureAuth is null");
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint is null");
        this.readBlockSize = Objects.requireNonNull(readBlockSize, "readBlockSize is null");
        this.writeBlockSize = Objects.requireNonNull(writeBlockSize, "writeBlockSize is null");
        Preconditions.checkArgument((maxWriteConcurrency >= 0 ? 1 : 0) != 0, (Object)"maxWriteConcurrency is negative");
        this.maxWriteConcurrency = maxWriteConcurrency;
        this.maxSingleUploadSize = Objects.requireNonNull(maxSingleUploadSize, "maxSingleUploadSize is null");
        this.tracingOptions = new OpenTelemetryTracingOptions().setOpenTelemetry(openTelemetry);
        this.connectionProvider = ConnectionProvider.create((String)applicationId, (int)maxHttpRequests);
        this.eventLoopGroup = new MultiThreadIoEventLoopGroup(maxHttpRequests, NioIoHandler.newFactory());
        HttpClientOptions clientOptions = new HttpClientOptions();
        clientOptions.setTracingOptions(this.tracingOptions);
        clientOptions.setApplicationId(applicationId);
        this.httpClient = AzureFileSystemFactory.createAzureHttpClient(this.connectionProvider, this.eventLoopGroup, clientOptions);
    }

    @PreDestroy
    public void destroy() {
        if (this.connectionProvider != null) {
            this.connectionProvider.dispose();
        }
        if (this.eventLoopGroup != null) {
            try {
                this.eventLoopGroup.shutdownGracefully().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    public TrinoFileSystem create(ConnectorIdentity identity) {
        return new AzureFileSystem(this.httpClient, this.tracingOptions, this.auth, this.endpoint, this.readBlockSize, this.writeBlockSize, this.maxWriteConcurrency, this.maxSingleUploadSize);
    }

    public static HttpClient createAzureHttpClient(ConnectionProvider connectionProvider, EventLoopGroup eventLoopGroup, HttpClientOptions clientOptions) {
        return new NettyAsyncHttpClientBuilder().proxy(clientOptions.getProxyOptions()).configuration(clientOptions.getConfiguration()).connectTimeout(clientOptions.getConnectTimeout()).writeTimeout(clientOptions.getWriteTimeout()).readTimeout(clientOptions.getReadTimeout()).responseTimeout(clientOptions.getResponseTimeout()).connectionProvider(connectionProvider).eventLoopGroup(eventLoopGroup).build();
    }
}

