/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import alluxio.client.file.cache.CacheManager;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.InstancedConfiguration;
import com.google.inject.Inject;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.alluxio.AlluxioCacheStats;
import io.trino.filesystem.alluxio.AlluxioFileSystemCache;
import io.trino.filesystem.alluxio.AlluxioFileSystemCacheConfig;
import io.trino.filesystem.cache.AllowFilesystemCacheOnCoordinator;
import io.trino.filesystem.cache.TrinoFileSystemCache;
import java.io.IOException;
import java.util.Optional;

public class AlluxioCoordinatorFileSystemCache
implements TrinoFileSystemCache {
    private final Optional<AlluxioFileSystemCache> alluxioFileSystemCache;

    @Inject
    public AlluxioCoordinatorFileSystemCache(@AllowFilesystemCacheOnCoordinator boolean allowFilesystemCacheOnCoordinator, Tracer tracer, AlluxioFileSystemCacheConfig config, AlluxioCacheStats statistics) throws IOException {
        if (allowFilesystemCacheOnCoordinator) {
            this.alluxioFileSystemCache = Optional.of(new AlluxioFileSystemCache(tracer, config, statistics));
        } else {
            this.alluxioFileSystemCache = Optional.empty();
            try {
                CacheManager cacheManager = CacheManager.Factory.create((AlluxioConfiguration)new InstancedConfiguration(new AlluxioProperties()));
                cacheManager.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public TrinoInput cacheInput(TrinoInputFile delegate, String key) throws IOException {
        if (this.alluxioFileSystemCache.isPresent()) {
            return this.alluxioFileSystemCache.get().cacheInput(delegate, key);
        }
        return delegate.newInput();
    }

    public TrinoInputStream cacheStream(TrinoInputFile delegate, String key) throws IOException {
        if (this.alluxioFileSystemCache.isPresent()) {
            return this.alluxioFileSystemCache.get().cacheStream(delegate, key);
        }
        return delegate.newStream();
    }

    public void expire(Location source) throws IOException {
    }
}

