/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import alluxio.client.file.CacheContext;
import alluxio.client.file.URIStatus;
import alluxio.client.file.cache.CacheManager;
import alluxio.conf.AlluxioConfiguration;
import alluxio.wire.FileInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.alluxio.AlluxioCacheStats;
import io.trino.filesystem.alluxio.AlluxioConfigurationFactory;
import io.trino.filesystem.alluxio.AlluxioFileSystemCacheConfig;
import io.trino.filesystem.alluxio.AlluxioInput;
import io.trino.filesystem.alluxio.AlluxioInputStream;
import io.trino.filesystem.alluxio.TracingCacheManager;
import io.trino.filesystem.cache.TrinoFileSystemCache;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class AlluxioFileSystemCache
implements TrinoFileSystemCache {
    private final Tracer tracer;
    private final DataSize pageSize;
    private final CacheManager cacheManager;
    private final AlluxioConfiguration config;
    private final AlluxioCacheStats statistics;
    private final HashFunction hashFunction = Hashing.murmur3_128();

    @Inject
    public AlluxioFileSystemCache(Tracer tracer, AlluxioFileSystemCacheConfig config, AlluxioCacheStats statistics) throws IOException {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.config = AlluxioConfigurationFactory.create(Objects.requireNonNull(config, "config is null"));
        this.pageSize = config.getCachePageSize();
        this.cacheManager = CacheManager.Factory.create((AlluxioConfiguration)this.config);
        this.statistics = Objects.requireNonNull(statistics, "statistics is null");
    }

    public TrinoInput cacheInput(TrinoInputFile delegate, String key) throws IOException {
        return new AlluxioInput(this.tracer, delegate, key, this.uriStatus(delegate, key), new TracingCacheManager(this.tracer, key, this.pageSize, this.cacheManager), this.config, this.statistics);
    }

    public TrinoInputStream cacheStream(TrinoInputFile delegate, String key) throws IOException {
        return new AlluxioInputStream(this.tracer, delegate, key, this.uriStatus(delegate, key), new TracingCacheManager(this.tracer, key, this.pageSize, this.cacheManager), this.config, this.statistics);
    }

    public void expire(Location source) throws IOException {
    }

    @PreDestroy
    public void shutdown() throws Exception {
        this.cacheManager.close();
    }

    @VisibleForTesting
    protected URIStatus uriStatus(TrinoInputFile file, String key) throws IOException {
        FileInfo info = new FileInfo().setPath(file.location().toString()).setLength(file.length());
        String cacheIdentifier = this.hashFunction.hashString((CharSequence)key, StandardCharsets.UTF_8).toString();
        return new URIStatus(info, CacheContext.defaults().setCacheIdentifier(cacheIdentifier));
    }
}

