/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.ExceptionAttributes;

public class AlluxioTracing {
    private AlluxioTracing() {
    }

    public static <T, E extends Exception> T withTracing(Span span, CheckedSupplier<T, E> supplier) throws E {
        try {
            T t;
            block11: {
                Scope ignored = span.makeCurrent();
                try {
                    t = supplier.get();
                    if (ignored == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t2) {
                        span.setStatus(StatusCode.ERROR, t2.getMessage());
                        span.recordException(t2, Attributes.of((AttributeKey)ExceptionAttributes.EXCEPTION_ESCAPED, (Object)true));
                        throw t2;
                    }
                }
                ignored.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    public static <E extends Exception> void withTracing(Span span, CheckedRunnable<E> supplier) throws E {
        try (Scope ignored = span.makeCurrent();){
            supplier.run();
        }
        catch (Throwable t) {
            span.setStatus(StatusCode.ERROR, t.getMessage());
            span.recordException(t, Attributes.of((AttributeKey)ExceptionAttributes.EXCEPTION_ESCAPED, (Object)true));
            throw t;
        }
        finally {
            span.end();
        }
    }

    public static interface CheckedSupplier<T, E extends Exception> {
        public T get() throws E;
    }

    public static interface CheckedRunnable<E extends Exception> {
        public void run() throws E;
    }
}

