/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.memory.MemoryFileSystem;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.Random;

class IncompleteStreamMemoryFileSystem
extends MemoryFileSystem {
    IncompleteStreamMemoryFileSystem() {
    }

    public TrinoInputFile newInputFile(Location location) {
        return new IncompleteStreamInputFile(super.newInputFile(location));
    }

    private static class IncompleteStreamInputFile
    implements TrinoInputFile {
        private final TrinoInputFile delegate;

        public IncompleteStreamInputFile(TrinoInputFile delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        public TrinoInput newInput() throws IOException {
            return this.delegate.newInput();
        }

        public TrinoInputStream newStream() throws IOException {
            return new IncompleteTrinoInputStream(this.delegate.newStream());
        }

        public long length() throws IOException {
            return this.delegate.length();
        }

        public Instant lastModified() throws IOException {
            return this.delegate.lastModified();
        }

        public boolean exists() throws IOException {
            return this.delegate.exists();
        }

        public Location location() {
            return this.delegate.location();
        }
    }

    static class IncompleteTrinoInputStream
    extends TrinoInputStream {
        private final TrinoInputStream delegate;
        private final Random random;

        public IncompleteTrinoInputStream(TrinoInputStream delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.random = new Random(42L);
        }

        public int read() throws IOException {
            return this.delegate.read();
        }

        public int read(byte[] buff, int off, int len) throws IOException {
            return this.delegate.read(buff, off, this.random.nextInt(0, len + 1));
        }

        public long getPosition() throws IOException {
            return this.delegate.getPosition();
        }

        public void seek(long position) throws IOException {
            this.delegate.seek(position);
        }
    }
}

