/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import com.google.common.collect.ImmutableList;
import io.airlift.tracing.Tracing;
import io.airlift.units.DataSize;
import io.trino.filesystem.AbstractTestTrinoFileSystem;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.alluxio.AlluxioCacheStats;
import io.trino.filesystem.alluxio.AlluxioFileSystemCache;
import io.trino.filesystem.alluxio.AlluxioFileSystemCacheConfig;
import io.trino.filesystem.alluxio.IncompleteStreamMemoryFileSystem;
import io.trino.filesystem.cache.CacheFileSystem;
import io.trino.filesystem.cache.CacheKeyProvider;
import io.trino.filesystem.cache.DefaultCacheKeyProvider;
import io.trino.filesystem.cache.TrinoFileSystemCache;
import io.trino.filesystem.memory.MemoryFileSystem;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;

public class TestAlluxioCacheFileSystem
extends AbstractTestTrinoFileSystem {
    private MemoryFileSystem memoryFileSystem;
    private CacheFileSystem fileSystem;
    private AlluxioFileSystemCache cache;
    private Path tempDirectory;

    @BeforeAll
    void beforeAll() throws IOException {
        this.tempDirectory = Files.createTempDirectory("test", new FileAttribute[0]);
        Path cacheDirectory = this.tempDirectory.resolve("cache");
        Files.createDirectory(cacheDirectory, new FileAttribute[0]);
        AlluxioFileSystemCacheConfig configuration = new AlluxioFileSystemCacheConfig().setCacheDirectories((List)ImmutableList.of((Object)cacheDirectory.toAbsolutePath().toString())).setCachePageSize(DataSize.valueOf((String)"32003B")).disableTTL().setMaxCacheSizes((List)ImmutableList.of((Object)DataSize.valueOf((String)"100MB")));
        this.memoryFileSystem = new IncompleteStreamMemoryFileSystem();
        this.cache = new AlluxioFileSystemCache(Tracing.noopTracer(), configuration, new AlluxioCacheStats());
        this.fileSystem = new CacheFileSystem((TrinoFileSystem)this.memoryFileSystem, (TrinoFileSystemCache)this.cache, (CacheKeyProvider)new DefaultCacheKeyProvider());
    }

    @AfterAll
    void afterAll() throws IOException {
        this.cleanupFiles(this.tempDirectory);
        Files.delete(this.tempDirectory);
    }

    private void cleanupFiles(Path directory) throws IOException {
        try (Stream<Path> walk = Files.walk(directory, new FileVisitOption[0]);){
            Iterator iterator = walk.sorted(Comparator.reverseOrder()).iterator();
            while (iterator.hasNext()) {
                Path path = (Path)iterator.next();
                if (path.equals(directory)) continue;
                Files.delete(path);
            }
        }
    }

    protected boolean isHierarchical() {
        return false;
    }

    protected TrinoFileSystem getFileSystem() {
        return this.fileSystem;
    }

    protected Location getRootLocation() {
        return Location.of((String)"memory://");
    }

    protected void verifyFileSystemIsEmpty() {
        Assertions.assertThat((boolean)this.memoryFileSystem.isEmpty()).isTrue();
    }
}

