/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.filesystem.alluxio.AlluxioConfigurationFactory;
import io.trino.filesystem.alluxio.AlluxioFileSystemCacheConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestAlluxioFileSystemCacheConfig {
    TestAlluxioFileSystemCacheConfig() {
    }

    @Test
    public void testInvalidConfiguration() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AlluxioConfigurationFactory.create((AlluxioFileSystemCacheConfig)new AlluxioFileSystemCacheConfig().setCacheDirectories((List)ImmutableList.of((Object)"/cache1", (Object)"/cache2")).setMaxCacheDiskUsagePercentages((List)ImmutableList.of((Object)0)).setMaxCacheSizes((List)ImmutableList.of((Object)DataSize.valueOf((String)"1B"))))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Either fs.cache.max-sizes or fs.cache.max-disk-usage-percentages must be specified");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AlluxioConfigurationFactory.create((AlluxioFileSystemCacheConfig)new AlluxioFileSystemCacheConfig().setCacheDirectories((List)ImmutableList.of((Object)"/cache1", (Object)"/cache2")).setMaxCacheSizes((List)ImmutableList.of((Object)DataSize.valueOf((String)"1B"))))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("fs.cache.directories and fs.cache.max-sizes must have the same size");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AlluxioConfigurationFactory.create((AlluxioFileSystemCacheConfig)new AlluxioFileSystemCacheConfig().setCacheDirectories((List)ImmutableList.of((Object)"/cache1", (Object)"/cache2")).setMaxCacheDiskUsagePercentages((List)ImmutableList.of((Object)0)))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("fs.cache.directories and fs.cache.max-disk-usage-percentages must have the same size");
    }

    @Test
    void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((AlluxioFileSystemCacheConfig)ConfigAssertions.recordDefaults(AlluxioFileSystemCacheConfig.class)).setCacheDirectories((List)ImmutableList.of()).setCachePageSize(DataSize.valueOf((String)"1MB")).setMaxCacheSizes((List)ImmutableList.of()).setMaxCacheDiskUsagePercentages((List)ImmutableList.of()).setCacheTTL(Duration.valueOf((String)"7d")));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path cacheDirectory = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = ImmutableMap.builder().put((Object)"fs.cache.directories", (Object)cacheDirectory.toString()).put((Object)"fs.cache.page-size", (Object)"7MB").put((Object)"fs.cache.max-sizes", (Object)"1GB").put((Object)"fs.cache.max-disk-usage-percentages", (Object)"50").put((Object)"fs.cache.ttl", (Object)"1d").buildOrThrow();
        AlluxioFileSystemCacheConfig expected = new AlluxioFileSystemCacheConfig().setCacheDirectories((List)ImmutableList.of((Object)cacheDirectory.toString())).setCachePageSize(DataSize.valueOf((String)"7MB")).setMaxCacheSizes((List)ImmutableList.of((Object)DataSize.valueOf((String)"1GB"))).setMaxCacheDiskUsagePercentages((List)ImmutableList.of((Object)50)).setCacheTTL(Duration.valueOf((String)"1d"));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testTotalSpaceCalculation() throws IOException {
        Path cacheDirectory = Files.createTempFile(null, null, new FileAttribute[0]);
        Assertions.assertThat((long)AlluxioConfigurationFactory.totalSpace((Path)cacheDirectory)).isEqualTo(cacheDirectory.toFile().getTotalSpace());
        Assertions.assertThat((long)AlluxioConfigurationFactory.totalSpace((Path)cacheDirectory.resolve(Path.of("does-not-exist", new String[0])))).isEqualTo(cacheDirectory.toFile().getTotalSpace());
    }
}

