/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.tracing.Tracing;
import io.airlift.units.DataSize;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.alluxio.AlluxioCacheStats;
import io.trino.filesystem.alluxio.AlluxioFileSystemCache;
import io.trino.filesystem.alluxio.AlluxioFileSystemCacheConfig;
import io.trino.filesystem.alluxio.IncompleteStreamMemoryFileSystem;
import io.trino.filesystem.alluxio.TestingCacheKeyProvider;
import io.trino.filesystem.cache.CacheFileSystem;
import io.trino.filesystem.cache.CacheKeyProvider;
import io.trino.filesystem.cache.TrinoFileSystemCache;
import io.trino.filesystem.memory.MemoryFileSystemFactory;
import io.trino.spi.security.ConnectorIdentity;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_METHOD)
public class TestFuzzAlluxioCacheFileSystem {
    private static final DataSize CACHE_SIZE = DataSize.ofBytes((long)8192L);
    private static final DataSize PAGE_SIZE = DataSize.ofBytes((long)128L);

    @Test
    public void testFuzzTrinoInputReadFully() throws IOException {
        this.fuzzTrinoInputOperation((fs, l) -> fs.newInputFile(l).newInput(), (trinoInput, position, buffer, bufferOffset, bufferLength) -> {
            trinoInput.readFully(position, buffer, bufferOffset, bufferLength);
            return bufferLength - bufferOffset;
        });
    }

    @Test
    public void testFuzzTrinoInputReadTail() throws IOException {
        this.fuzzTrinoInputOperation((fs, l) -> fs.newInputFile(l).newInput(), (input, position, buffer, bufferOffset, bufferLength) -> input.readTail(buffer, bufferOffset, bufferLength));
    }

    @Test
    public void testFuzzTrinoInputStreamRead() throws IOException {
        this.fuzzTrinoInputOperation((fs, l) -> fs.newInputFile(l).newStream(), (input, position, buffer, bufferOffset, bufferLength) -> {
            input.seek(position);
            return input.read(buffer, bufferOffset, bufferLength);
        });
    }

    @Test
    public void testFuzzTrinoInputStreamReadSkip() throws IOException {
        this.fuzzTrinoInputOperation((fs, l) -> fs.newInputFile(l).newStream(), (input, position, buffer, bufferOffset, bufferLength) -> {
            input.skip(position);
            return input.read(buffer, bufferOffset, bufferLength);
        });
    }

    private <T> void fuzzTrinoInputOperation(CreateTrinoInput<T> createInput, TrinoInputOperation<T> operation) throws IOException {
        Random random = new Random();
        try (TestMemoryFileSystem expectedFileSystemState = new TestMemoryFileSystem();
             TestAlluxioFileSystem actualFileSystemState = new TestAlluxioFileSystem();){
            TrinoFileSystem expectedFileSystem = expectedFileSystemState.create();
            TrinoFileSystem testFileSystem = actualFileSystemState.create();
            Location expectedLocation = expectedFileSystemState.tempLocation();
            Location testLocation = actualFileSystemState.tempLocation();
            int fileSize = random.nextInt(0, Math.toIntExact(CACHE_SIZE.toBytes() / 2L));
            TestFuzzAlluxioCacheFileSystem.createTestFile(expectedFileSystem, expectedLocation, fileSize);
            TestFuzzAlluxioCacheFileSystem.createTestFile(testFileSystem, testLocation, fileSize);
            T expectedInput = createInput.apply(expectedFileSystem, expectedLocation);
            T actualInput = createInput.apply(testFileSystem, testLocation);
            for (int i = 0; i < 1000; ++i) {
                this.applyOperation(random, fileSize, expectedInput, actualInput, operation);
            }
        }
    }

    public <T> void applyOperation(Random random, int fileSize, T expectedInput, T actualInput, TrinoInputOperation<T> operation) throws IOException {
        long position = random.nextLong(0L, fileSize + 1);
        int bufferSize = random.nextInt(0, fileSize + 1);
        int bufferOffset = random.nextInt(0, bufferSize + 1);
        int length = bufferSize - bufferOffset;
        byte[] bufferExpected = new byte[bufferSize];
        byte[] bufferActual = new byte[bufferSize];
        int expectedBytesRead = operation.apply(expectedInput, position, bufferExpected, bufferOffset, length);
        int actualBytesRead = operation.apply(actualInput, position, bufferActual, bufferOffset, length);
        Assertions.assertThat((int)actualBytesRead).isEqualTo(expectedBytesRead);
        Assertions.assertThat((Comparable)Slices.wrappedBuffer((byte[])bufferActual)).isEqualTo((Object)Slices.wrappedBuffer((byte[])bufferExpected));
    }

    private static void createTestFile(TrinoFileSystem fileSystem, Location location, int fileSize) throws IOException {
        try (OutputStream output = fileSystem.newOutputFile(location).create();){
            byte[] bytes = new byte[4];
            Slice slice = Slices.wrappedBuffer((byte[])bytes);
            for (int i = 0; i < fileSize; ++i) {
                slice.setInt(0, i);
                output.write(bytes, 0, Math.min(fileSize - i, 4));
            }
        }
    }

    private static interface CreateTrinoInput<T> {
        public T apply(TrinoFileSystem var1, Location var2) throws IOException;
    }

    private static interface TrinoInputOperation<T> {
        public int apply(T var1, long var2, byte[] var4, int var5, int var6) throws IOException;
    }

    private static class TestMemoryFileSystem
    implements TestFileSystem {
        private TestMemoryFileSystem() {
        }

        @Override
        public TrinoFileSystem create() {
            return new MemoryFileSystemFactory().create(ConnectorIdentity.ofUser((String)""));
        }

        @Override
        public Location tempLocation() {
            return Location.of((String)"memory:///fuzz");
        }

        @Override
        public void close() {
        }
    }

    private static class TestAlluxioFileSystem
    implements TestFileSystem {
        private Path tempDirectory;

        private TestAlluxioFileSystem() {
        }

        @Override
        public TrinoFileSystem create() throws IOException {
            this.tempDirectory = Files.createTempDirectory("test", new FileAttribute[0]);
            Path cacheDirectory = Files.createDirectory(this.tempDirectory.resolve("cache"), new FileAttribute[0]);
            AlluxioFileSystemCacheConfig configuration = new AlluxioFileSystemCacheConfig().setCacheDirectories((List)ImmutableList.of((Object)cacheDirectory.toAbsolutePath().toString())).setCachePageSize(PAGE_SIZE).disableTTL().setMaxCacheSizes((List)ImmutableList.of((Object)CACHE_SIZE));
            AlluxioFileSystemCache alluxioCache = new AlluxioFileSystemCache(Tracing.noopTracer(), configuration, new AlluxioCacheStats());
            return new CacheFileSystem((TrinoFileSystem)new IncompleteStreamMemoryFileSystem(), (TrinoFileSystemCache)alluxioCache, (CacheKeyProvider)new TestingCacheKeyProvider());
        }

        @Override
        public Location tempLocation() {
            return Location.of((String)"memory:///fuzz");
        }

        @Override
        public void close() {
            this.tempDirectory.toFile().delete();
        }
    }

    private static interface TestFileSystem
    extends Closeable {
        public TrinoFileSystem create() throws IOException;

        public Location tempLocation();
    }
}

