/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.cache.CacheKeyProvider;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class TestingCacheKeyProvider
implements CacheKeyProvider {
    private final AtomicInteger cacheVersion = new AtomicInteger(0);

    public Optional<String> getCacheKey(TrinoInputFile inputFile) {
        return Optional.of(TestingCacheKeyProvider.testingCacheKeyForLocation(inputFile.location(), this.cacheVersion.get()));
    }

    public static String testingCacheKeyForLocation(Location location, int generation) {
        return location.toString() + "-v" + generation;
    }

    public void increaseCacheVersion() {
        this.cacheVersion.incrementAndGet();
    }

    public int currentCacheVersion() {
        return this.cacheVersion.get();
    }
}

