/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import alluxio.client.file.URIStatus;
import alluxio.client.file.cache.CacheManager;
import alluxio.conf.AlluxioConfiguration;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.alluxio.AlluxioCacheStats;
import io.trino.filesystem.alluxio.AlluxioInputHelper;
import io.trino.filesystem.tracing.CacheSystemAttributes;
import io.trino.filesystem.tracing.Tracing;
import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;

public class AlluxioInput
implements TrinoInput {
    private final TrinoInputFile inputFile;
    private final long fileLength;
    private final AlluxioCacheStats statistics;
    private final String cacheKey;
    private final AlluxioInputHelper helper;
    private final Tracer tracer;
    private TrinoInput input;
    private boolean closed;

    public AlluxioInput(Tracer tracer, TrinoInputFile inputFile, String cacheKey, URIStatus status, CacheManager cacheManager, AlluxioConfiguration configuration, AlluxioCacheStats statistics) {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.inputFile = Objects.requireNonNull(inputFile, "inputFile is null");
        this.fileLength = Objects.requireNonNull(status, "status is null").getLength();
        this.statistics = Objects.requireNonNull(statistics, "statistics is null");
        this.cacheKey = Objects.requireNonNull(cacheKey, "cacheKey is null");
        this.helper = new AlluxioInputHelper(tracer, inputFile.location(), cacheKey, status, cacheManager, configuration, statistics);
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.ensureOpen();
        Objects.checkFromIndexSize(offset, length, buffer.length);
        if (position < 0L) {
            throw new IOException("Negative seek offset");
        }
        if (length == 0) {
            return;
        }
        int bytesRead = this.helper.doCacheRead(position, buffer, offset, length);
        if (length > bytesRead && position + (long)bytesRead == this.fileLength) {
            throw new EOFException("Read %s of %s requested bytes: %s".formatted(bytesRead, length, this.inputFile.location()));
        }
        this.doExternalRead(position + (long)bytesRead, buffer, offset + bytesRead, length - bytesRead);
    }

    private int doExternalRead(long position, byte[] buffer, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        Span span = this.tracer.spanBuilder("Alluxio.readExternal").setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)this.cacheKey).setAttribute(CacheSystemAttributes.CACHE_FILE_LOCATION, (Object)this.inputFile.location().toString()).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_SIZE, (Object)length).setAttribute(CacheSystemAttributes.CACHE_FILE_READ_POSITION, (Object)position).startSpan();
        return (Integer)Tracing.withTracing((Span)span, () -> {
            AlluxioInputHelper.PageAlignedRead aligned = this.helper.alignRead(position, length);
            byte[] readBuffer = new byte[aligned.length()];
            this.getInput().readFully(aligned.pageStart(), readBuffer, 0, readBuffer.length);
            this.helper.putCache(aligned.pageStart(), aligned.pageEnd(), readBuffer, aligned.length());
            System.arraycopy(readBuffer, aligned.pageOffset(), buffer, offset, length);
            this.statistics.recordExternalRead(readBuffer.length);
            return length;
        });
    }

    private TrinoInput getInput() throws IOException {
        if (this.input == null) {
            this.input = this.inputFile.newInput();
        }
        return this.input;
    }

    public int readTail(byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.ensureOpen();
        Objects.checkFromIndexSize(bufferOffset, bufferLength, buffer.length);
        int readSize = (int)Math.min(this.fileLength, (long)bufferLength);
        this.readFully(this.fileLength - (long)readSize, buffer, bufferOffset, readSize);
        return readSize;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed: " + String.valueOf(this.inputFile.location()));
        }
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.input != null) {
            this.input.close();
        }
    }
}

