/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.filesystem.alluxio.AlluxioFileSystemCacheConfig;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class AlluxioConfigurationFactory {
    private AlluxioConfigurationFactory() {
    }

    public static AlluxioConfiguration create(AlluxioFileSystemCacheConfig config) {
        Preconditions.checkArgument((boolean)(config.getMaxCacheSizes().isEmpty() ^ config.getMaxCacheDiskUsagePercentages().isEmpty()), (String)"Either %s or %s must be specified", (Object)"fs.cache.max-sizes", (Object)"fs.cache.max-disk-usage-percentages");
        int size = config.getMaxCacheSizes().isEmpty() ? config.getMaxCacheDiskUsagePercentages().size() : config.getMaxCacheSizes().size();
        Preconditions.checkArgument((config.getCacheDirectories().size() == size ? 1 : 0) != 0, (String)"%s and %s must have the same size", (Object)"fs.cache.directories", (Object)(config.getMaxCacheSizes().isEmpty() ? "fs.cache.max-disk-usage-percentages" : "fs.cache.max-sizes"));
        config.getCacheDirectories().forEach(directory -> AlluxioConfigurationFactory.canWrite(Path.of(directory, new String[0])));
        List<DataSize> maxCacheSizes = config.getMaxCacheSizes().isEmpty() ? AlluxioConfigurationFactory.calculateMaxCacheSizes(config.getMaxCacheDiskUsagePercentages(), (List)config.getCacheDirectories().stream().map(directory -> AlluxioConfigurationFactory.totalSpace(Path.of(directory, new String[0]))).collect(ImmutableList.toImmutableList())) : config.getMaxCacheSizes();
        AlluxioProperties alluxioProperties = new AlluxioProperties();
        alluxioProperties.set(PropertyKey.USER_CLIENT_CACHE_ENABLED, (Object)true);
        alluxioProperties.set(PropertyKey.USER_CLIENT_CACHE_DIRS, (Object)String.join((CharSequence)",", config.getCacheDirectories()));
        alluxioProperties.set(PropertyKey.USER_CLIENT_CACHE_SIZE, (Object)String.join((CharSequence)",", maxCacheSizes.stream().map(DataSize::toBytesValueString).toList()));
        alluxioProperties.set(PropertyKey.USER_CLIENT_CACHE_PAGE_SIZE, (Object)config.getCachePageSize().toBytesValueString());
        Optional<Duration> ttl = config.getCacheTTL();
        if (ttl.isPresent()) {
            alluxioProperties.set(PropertyKey.USER_CLIENT_CACHE_TTL_THRESHOLD_SECONDS, (Object)ttl.orElseThrow().roundTo(TimeUnit.SECONDS));
            alluxioProperties.set(PropertyKey.USER_CLIENT_CACHE_TTL_ENABLED, (Object)true);
        }
        return new InstancedConfiguration(alluxioProperties);
    }

    private static void canWrite(Path path) {
        Path originalPath = path;
        while (!Files.exists(path, new LinkOption[0]) && path.getParent() != null) {
            path = path.getParent();
        }
        Preconditions.checkArgument((boolean)Files.isDirectory(path, new LinkOption[0]), (Object)String.format("Cache directory %s is not a directory", path));
        Preconditions.checkArgument((boolean)Files.isReadable(path), (Object)String.format("Cannot read from cache directory %s", originalPath));
        Preconditions.checkArgument((boolean)Files.isWritable(path), (Object)String.format("Cannot write to cache directory %s", originalPath));
    }

    @VisibleForTesting
    static long totalSpace(Path path) {
        while (!Files.exists(path, new LinkOption[0]) && path.getParent() != null) {
            path = path.getParent();
        }
        return path.toFile().getTotalSpace();
    }

    private static List<DataSize> calculateMaxCacheSizes(List<Integer> cachePercentages, List<Long> cacheDiskSizes) {
        ImmutableList.Builder maxCacheSizes = ImmutableList.builderWithExpectedSize((int)cacheDiskSizes.size());
        for (int i = 0; i < cacheDiskSizes.size(); ++i) {
            maxCacheSizes.add((Object)DataSize.of((long)Math.round((double)cachePercentages.get(i).intValue() / 100.0 * (double)cacheDiskSizes.get(i).longValue()), (DataSize.Unit)DataSize.Unit.BYTE));
        }
        return maxCacheSizes.build();
    }
}

