/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.alluxio;

import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.stats.DistributionStat;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class AlluxioCacheStats {
    private final DistributionStat externalReads = new DistributionStat();
    private final DistributionStat cacheReads = new DistributionStat();

    @Managed
    @Nested
    public DistributionStat getExternalReads() {
        return this.externalReads;
    }

    @Managed
    @Nested
    public DistributionStat getCacheReads() {
        return this.cacheReads;
    }

    public void recordCacheRead(int length) {
        this.cacheReads.add((long)length);
    }

    public void recordExternalRead(int length) {
        this.externalReads.add((long)length);
    }
}

