/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.gcs;

import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import com.google.common.base.Preconditions;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.gcs.GcsLocation;
import io.trino.filesystem.gcs.GcsUtils;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.OptionalLong;

final class GcsInput
implements TrinoInput {
    private final GcsLocation location;
    private final Storage storage;
    private final int readBlockSize;
    private final OptionalLong length;
    private boolean closed;

    public GcsInput(GcsLocation location, Storage storage, int readBlockSize, OptionalLong length) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.storage = Objects.requireNonNull(storage, "storage is null");
        Preconditions.checkArgument((readBlockSize >= 0 ? 1 : 0) != 0, (Object)"readBlockSize is negative");
        this.readBlockSize = readBlockSize;
        this.length = Objects.requireNonNull(length, "length is null");
    }

    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.ensureOpen();
        if (position < 0L) {
            throw new IOException("Negative seek offset");
        }
        Objects.checkFromIndexSize(bufferOffset, bufferLength, buffer.length);
        if (bufferLength == 0) {
            return;
        }
        try (ReadChannel readChannel = GcsUtils.getReadChannel(GcsUtils.getBlobOrThrow(this.storage, this.location, new Storage.BlobGetOption[0]), this.location, position, this.readBlockSize, this.length);){
            int readSize = this.readNBytes(readChannel, buffer, bufferOffset, bufferLength);
            if (readSize != bufferLength) {
                throw new EOFException("End of file reached before reading fully: " + String.valueOf(this.location));
            }
        }
        catch (RuntimeException e) {
            throw GcsUtils.handleGcsException(e, "reading file", this.location);
        }
    }

    public int readTail(byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        int n;
        block8: {
            this.ensureOpen();
            Objects.checkFromIndexSize(bufferOffset, bufferLength, buffer.length);
            Blob blob = GcsUtils.getBlobOrThrow(this.storage, this.location, new Storage.BlobGetOption[0]);
            long offset = Math.max(0L, this.length.orElse(blob.getSize()) - (long)bufferLength);
            ReadChannel readChannel = GcsUtils.getReadChannel(blob, this.location, offset, this.readBlockSize, this.length);
            try {
                n = this.readNBytes(readChannel, buffer, bufferOffset, bufferLength);
                if (readChannel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (readChannel != null) {
                        try {
                            readChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw GcsUtils.handleGcsException(e, "reading file", this.location);
                }
            }
            readChannel.close();
        }
        return n;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream closed: " + String.valueOf(this.location));
        }
    }

    public void close() {
        this.closed = true;
    }

    public String toString() {
        return this.location.toString();
    }

    private int readNBytes(ReadChannel readChannel, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        int readSize;
        int bytesRead;
        ByteBuffer wrappedBuffer = ByteBuffer.wrap(buffer, bufferOffset, bufferLength);
        for (readSize = 0; readSize < bufferLength && (bytesRead = readChannel.read(wrappedBuffer)) != -1; readSize += bytesRead) {
        }
        return readSize;
    }
}

