/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.gcs;

import com.google.cloud.WriteChannel;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.base.Preconditions;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.gcs.GcsLocation;
import io.trino.filesystem.gcs.GcsOutputStream;
import io.trino.filesystem.gcs.GcsUtils;
import io.trino.memory.context.AggregatedMemoryContext;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.util.Objects;

public class GcsOutputFile
implements TrinoOutputFile {
    private final GcsLocation location;
    private final Storage storage;
    private final long writeBlockSizeBytes;

    public GcsOutputFile(GcsLocation location, Storage storage, long writeBlockSizeBytes) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.storage = Objects.requireNonNull(storage, "storage is null");
        Preconditions.checkArgument((writeBlockSizeBytes >= 0L ? 1 : 0) != 0, (Object)"writeBlockSizeBytes is negative");
        this.writeBlockSizeBytes = writeBlockSizeBytes;
    }

    public void createOrOverwrite(byte[] data) throws IOException {
        try {
            this.storage.create(this.blobInfo(), data, new Storage.BlobTargetOption[0]);
        }
        catch (RuntimeException e) {
            throw GcsUtils.handleGcsException(e, "writing file", this.location);
        }
    }

    public void createExclusive(byte[] data) throws IOException {
        try {
            if (GcsUtils.getBlob(this.storage, this.location, new Storage.BlobGetOption[0]).isPresent()) {
                throw new FileAlreadyExistsException("File %s already exists".formatted(this.location));
            }
            this.storage.create(this.blobInfo(), data, new Storage.BlobTargetOption[]{Storage.BlobTargetOption.doesNotExist()});
        }
        catch (RuntimeException e) {
            this.throwIfAlreadyExists(e);
            throw GcsUtils.handleGcsException(e, "writing file", this.location);
        }
    }

    public OutputStream create(AggregatedMemoryContext memoryContext) throws IOException {
        try {
            if (GcsUtils.getBlob(this.storage, this.location, new Storage.BlobGetOption[0]).isPresent()) {
                throw new FileAlreadyExistsException("File %s already exists".formatted(this.location));
            }
            WriteChannel writeChannel = this.storage.writer(this.blobInfo(), new Storage.BlobWriteOption[]{Storage.BlobWriteOption.doesNotExist()});
            return new GcsOutputStream(this.location, writeChannel, memoryContext, this.writeBlockSizeBytes);
        }
        catch (RuntimeException e) {
            this.throwIfAlreadyExists(e);
            throw GcsUtils.handleGcsException(e, "writing file", this.location);
        }
    }

    public Location location() {
        return this.location.location();
    }

    private BlobInfo blobInfo() {
        return BlobInfo.newBuilder((String)this.location.bucket(), (String)this.location.path()).build();
    }

    private void throwIfAlreadyExists(RuntimeException e) throws FileAlreadyExistsException {
        StorageException se;
        if (e instanceof StorageException && (se = (StorageException)e).getCode() == 412) {
            throw new FileAlreadyExistsException(this.location.toString());
        }
    }
}

