/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.gcs;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.Storage;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.gcs.GcsInput;
import io.trino.filesystem.gcs.GcsInputStream;
import io.trino.filesystem.gcs.GcsLocation;
import io.trino.filesystem.gcs.GcsUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class GcsInputFile
implements TrinoInputFile {
    private final GcsLocation location;
    private final Storage storage;
    private final int readBlockSize;
    private final OptionalLong predeclaredLength;
    private OptionalLong length;
    private Optional<Instant> lastModified = Optional.empty();

    public GcsInputFile(GcsLocation location, Storage storage, int readBockSize, OptionalLong predeclaredLength) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.storage = Objects.requireNonNull(storage, "storage is null");
        this.readBlockSize = readBockSize;
        this.predeclaredLength = Objects.requireNonNull(predeclaredLength, "length is null");
        this.length = OptionalLong.empty();
    }

    public TrinoInput newInput() throws IOException {
        return new GcsInput(this.location, this.storage, this.readBlockSize, this.predeclaredLength);
    }

    public TrinoInputStream newStream() throws IOException {
        Blob blob = GcsUtils.getBlobOrThrow(this.storage, this.location, new Storage.BlobGetOption[0]);
        return new GcsInputStream(this.location, blob, this.readBlockSize, this.predeclaredLength);
    }

    public long length() throws IOException {
        if (this.predeclaredLength.isPresent()) {
            return this.predeclaredLength.getAsLong();
        }
        if (this.length.isEmpty()) {
            this.loadProperties();
        }
        return this.length.orElseThrow();
    }

    public Instant lastModified() throws IOException {
        if (this.lastModified.isEmpty()) {
            this.loadProperties();
        }
        return this.lastModified.orElseThrow();
    }

    public boolean exists() throws IOException {
        Optional<Blob> blob = GcsUtils.getBlob(this.storage, this.location, new Storage.BlobGetOption[0]);
        return blob.isPresent() && blob.get().exists(new Blob.BlobSourceOption[0]);
    }

    public Location location() {
        return this.location.location();
    }

    private void loadProperties() throws IOException {
        Blob blob = GcsUtils.getBlobOrThrow(this.storage, this.location, new Storage.BlobGetOption[0]);
        try {
            this.length = OptionalLong.of(blob.getSize());
            this.lastModified = Optional.of(Instant.from(blob.getUpdateTimeOffsetDateTime()));
        }
        catch (RuntimeException e) {
            throw GcsUtils.handleGcsException(e, "fetching properties for file", this.location);
        }
    }
}

