/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.gcs;

import com.google.cloud.ReadChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.common.base.Preconditions;
import io.trino.filesystem.Location;
import io.trino.filesystem.gcs.GcsLocation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class GcsUtils {
    private GcsUtils() {
    }

    public static IOException handleGcsException(RuntimeException exception, String action, GcsLocation location) throws IOException {
        throw new IOException("Error %s: %s".formatted(action, location), exception);
    }

    public static IOException handleGcsException(RuntimeException exception, String action, Collection<Location> locations) throws IOException {
        throw new IOException("Error %s: %s".formatted(action, locations), exception);
    }

    public static ReadChannel getReadChannel(Blob blob, GcsLocation location, long position, int readBlockSize, OptionalLong limit) throws IOException {
        long fileSize = Objects.requireNonNull(blob.getSize(), "blob size is null");
        if (position >= fileSize) {
            throw new IOException("Cannot read at %s. File size is %s: %s".formatted(position, fileSize, location));
        }
        ReadChannel readChannel = blob.reader(new Blob.BlobSourceOption[]{Blob.BlobSourceOption.shouldReturnRawInputStream((boolean)true)});
        readChannel.setChunkSize(readBlockSize);
        readChannel.seek(position);
        if (limit.isPresent()) {
            return readChannel.limit(limit.getAsLong());
        }
        return readChannel;
    }

    public static Optional<Blob> getBlob(Storage storage, GcsLocation location, Storage.BlobGetOption ... blobGetOptions) {
        Preconditions.checkArgument((!location.path().isEmpty() ? 1 : 0) != 0, (String)"Path for location %s is empty", (Object)location);
        return Optional.ofNullable(storage.get(BlobId.of((String)location.bucket(), (String)location.path()), blobGetOptions));
    }

    public static Blob getBlobOrThrow(Storage storage, GcsLocation location, Storage.BlobGetOption ... blobGetOptions) throws IOException {
        return GcsUtils.getBlob(storage, location, blobGetOptions).orElseThrow(() -> new FileNotFoundException("File %s not found".formatted(location)));
    }
}

