/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.gcs;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.airlift.concurrent.Threads;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.gcs.GcsFileSystem;
import io.trino.filesystem.gcs.GcsFileSystemConfig;
import io.trino.filesystem.gcs.GcsStorageFactory;
import io.trino.spi.security.ConnectorIdentity;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class GcsFileSystemFactory
implements TrinoFileSystemFactory {
    private final int readBlockSizeBytes;
    private final long writeBlockSizeBytes;
    private final int pageSize;
    private final int batchSize;
    private final ListeningExecutorService executorService;
    private final GcsStorageFactory storageFactory;

    @Inject
    public GcsFileSystemFactory(GcsFileSystemConfig config, GcsStorageFactory storageFactory) {
        this.readBlockSizeBytes = Math.toIntExact(config.getReadBlockSize().toBytes());
        this.writeBlockSizeBytes = config.getWriteBlockSize().toBytes();
        this.pageSize = config.getPageSize();
        this.batchSize = config.getBatchSize();
        this.storageFactory = Objects.requireNonNull(storageFactory, "storageFactory is null");
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"trino-filesystem-gcs-%S")));
    }

    @PreDestroy
    public void stop() {
        this.executorService.shutdownNow();
    }

    public TrinoFileSystem create(ConnectorIdentity identity) {
        return new GcsFileSystem(this.executorService, this.storageFactory.create(identity), this.readBlockSizeBytes, this.writeBlockSizeBytes, this.pageSize, this.batchSize);
    }
}

