/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.gcs;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.gcs.GcsLocation;
import io.trino.filesystem.gcs.GcsUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;

public class GcsFileIterator
implements FileIterator {
    private final GcsLocation location;
    private final Iterator<Blob> blobIterator;

    public GcsFileIterator(GcsLocation location, Page<Blob> page) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.blobIterator = page.streamAll().filter(blob -> !blob.isDirectory()).filter(blob -> !blob.getName().endsWith("/")).iterator();
    }

    public boolean hasNext() throws IOException {
        try {
            return this.blobIterator.hasNext();
        }
        catch (RuntimeException e) {
            throw GcsUtils.handleGcsException(e, "listing files", this.location);
        }
    }

    public FileEntry next() throws IOException {
        try {
            Blob blob = this.blobIterator.next();
            long length = Objects.requireNonNull(blob.getSize(), "blob size is null");
            return new FileEntry(Location.of((String)(this.location.getBase() + blob.getName())), length, Instant.from(blob.getUpdateTimeOffsetDateTime()), Optional.empty());
        }
        catch (RuntimeException e) {
            throw GcsUtils.handleGcsException(e, "listing files", this.location);
        }
    }
}

