/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.manager;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigPropertyMetadata;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.alluxio.AlluxioFileSystemCacheModule;
import io.trino.filesystem.alluxio.AlluxioFileSystemFactory;
import io.trino.filesystem.alluxio.AlluxioFileSystemModule;
import io.trino.filesystem.azure.AzureFileSystemFactory;
import io.trino.filesystem.azure.AzureFileSystemModule;
import io.trino.filesystem.cache.CacheFileSystemFactory;
import io.trino.filesystem.cache.CacheKeyProvider;
import io.trino.filesystem.cache.CachingHostAddressProvider;
import io.trino.filesystem.cache.DefaultCacheKeyProvider;
import io.trino.filesystem.cache.DefaultCachingHostAddressProvider;
import io.trino.filesystem.cache.TrinoFileSystemCache;
import io.trino.filesystem.gcs.GcsFileSystemFactory;
import io.trino.filesystem.gcs.GcsFileSystemModule;
import io.trino.filesystem.local.LocalFileSystemConfig;
import io.trino.filesystem.local.LocalFileSystemFactory;
import io.trino.filesystem.manager.FileSystemConfig;
import io.trino.filesystem.manager.HdfsFileSystemLoader;
import io.trino.filesystem.memory.MemoryFileSystemCache;
import io.trino.filesystem.memory.MemoryFileSystemCacheModule;
import io.trino.filesystem.s3.FileSystemS3;
import io.trino.filesystem.s3.S3FileSystemModule;
import io.trino.filesystem.switching.SwitchingFileSystemFactory;
import io.trino.filesystem.tracing.TracingFileSystemFactory;
import io.trino.spi.NodeManager;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class FileSystemModule
extends AbstractConfigurationAwareModule {
    private final String catalogName;
    private final NodeManager nodeManager;
    private final OpenTelemetry openTelemetry;
    private final boolean coordinatorFileCaching;

    public FileSystemModule(String catalogName, NodeManager nodeManager, OpenTelemetry openTelemetry, boolean coordinatorFileCaching) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.openTelemetry = Objects.requireNonNull(openTelemetry, "openTelemetry is null");
        this.coordinatorFileCaching = coordinatorFileCaching;
    }

    protected void setup(Binder binder) {
        FileSystemConfig config = (FileSystemConfig)this.buildConfigObject(FileSystemConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, HdfsFileSystemLoader.class);
        if (config.isHadoopEnabled()) {
            HdfsFileSystemLoader loader = new HdfsFileSystemLoader(this.getProperties(), !config.isNativeAzureEnabled(), !config.isNativeGcsEnabled(), !config.isNativeS3Enabled(), this.catalogName, this.nodeManager, this.openTelemetry);
            loader.configure().forEach((name, securitySensitive) -> this.consumeProperty(new ConfigPropertyMetadata(name, securitySensitive.booleanValue())));
            binder.bind(HdfsFileSystemLoader.class).toInstance((Object)loader);
        }
        MapBinder factories = MapBinder.newMapBinder((Binder)binder, String.class, TrinoFileSystemFactory.class);
        if (config.isAlluxioEnabled()) {
            this.install((Module)new AlluxioFileSystemModule());
            factories.addBinding((Object)"alluxio").to(AlluxioFileSystemFactory.class);
        }
        if (config.isNativeAzureEnabled()) {
            this.install((Module)new AzureFileSystemModule());
            factories.addBinding((Object)"abfs").to(AzureFileSystemFactory.class);
            factories.addBinding((Object)"abfss").to(AzureFileSystemFactory.class);
            factories.addBinding((Object)"wasb").to(AzureFileSystemFactory.class);
            factories.addBinding((Object)"wasbs").to(AzureFileSystemFactory.class);
        }
        if (config.isNativeS3Enabled()) {
            this.install((Module)new S3FileSystemModule());
            factories.addBinding((Object)"s3").to(Key.get(TrinoFileSystemFactory.class, FileSystemS3.class));
            factories.addBinding((Object)"s3a").to(Key.get(TrinoFileSystemFactory.class, FileSystemS3.class));
            factories.addBinding((Object)"s3n").to(Key.get(TrinoFileSystemFactory.class, FileSystemS3.class));
        }
        if (config.isNativeGcsEnabled()) {
            this.install((Module)new GcsFileSystemModule());
            factories.addBinding((Object)"gs").to(GcsFileSystemFactory.class);
        }
        if (config.isNativeLocalEnabled()) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(LocalFileSystemConfig.class);
            factories.addBinding((Object)"local").to(LocalFileSystemFactory.class);
            factories.addBinding((Object)"file").to(LocalFileSystemFactory.class);
        }
        OptionalBinder.newOptionalBinder((Binder)binder, CachingHostAddressProvider.class).setDefault().to(DefaultCachingHostAddressProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, CacheKeyProvider.class).setDefault().to(DefaultCacheKeyProvider.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, TrinoFileSystemCache.class);
        OptionalBinder.newOptionalBinder((Binder)binder, MemoryFileSystemCache.class);
        boolean isCoordinator = this.nodeManager.getCurrentNode().isCoordinator();
        if (config.isCacheEnabled()) {
            this.install((Module)new AlluxioFileSystemCacheModule(isCoordinator));
        }
        if (this.coordinatorFileCaching) {
            this.install((Module)new MemoryFileSystemCacheModule(isCoordinator));
        }
    }

    @Provides
    @Singleton
    static TrinoFileSystemFactory createFileSystemFactory(Optional<HdfsFileSystemLoader> hdfsFileSystemLoader, Map<String, TrinoFileSystemFactory> factories, Optional<TrinoFileSystemCache> fileSystemCache, Optional<MemoryFileSystemCache> memoryFileSystemCache, Optional<CacheKeyProvider> keyProvider, Tracer tracer) {
        Optional<TrinoFileSystemFactory> hdfsFactory = hdfsFileSystemLoader.map(HdfsFileSystemLoader::create);
        Function<Location, TrinoFileSystemFactory> loader = location -> location.scheme().map(factories::get).or(() -> hdfsFactory).orElseThrow(() -> new IllegalArgumentException("No factory for location: " + String.valueOf(location)));
        SwitchingFileSystemFactory delegate = new SwitchingFileSystemFactory(loader);
        delegate = new TracingFileSystemFactory(tracer, (TrinoFileSystemFactory)delegate);
        if (fileSystemCache.isPresent()) {
            return new CacheFileSystemFactory(tracer, (TrinoFileSystemFactory)delegate, fileSystemCache.orElseThrow(), keyProvider.orElseThrow());
        }
        if (memoryFileSystemCache.isPresent()) {
            return new CacheFileSystemFactory(tracer, (TrinoFileSystemFactory)delegate, (TrinoFileSystemCache)memoryFileSystemCache.orElseThrow(), keyProvider.orElseThrow());
        }
        return delegate;
    }
}

