/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.common.net.HostAndPort;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.DataSize;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class S3FileSystemConfig {
    private String awsAccessKey;
    private String awsSecretKey;
    private String endpoint;
    private String region;
    private boolean pathStyleAccess;
    private String iamRole;
    private String roleSessionName = "trino-filesystem";
    private String externalId;
    private String stsEndpoint;
    private String stsRegion;
    private S3SseType sseType = S3SseType.NONE;
    private String sseKmsKeyId;
    private DataSize streamingPartSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private boolean requesterPays;
    private Integer maxConnections;
    private HostAndPort httpProxy;
    private boolean httpProxySecure;

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    @Config(value="s3.aws-access-key")
    public S3FileSystemConfig setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
        return this;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    @Config(value="s3.aws-secret-key")
    @ConfigSecuritySensitive
    public S3FileSystemConfig setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @Config(value="s3.endpoint")
    public S3FileSystemConfig setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    @Config(value="s3.region")
    public S3FileSystemConfig setRegion(String region) {
        this.region = region;
        return this;
    }

    public boolean isPathStyleAccess() {
        return this.pathStyleAccess;
    }

    @Config(value="s3.path-style-access")
    @ConfigDescription(value="Use path-style access for all requests to S3")
    public S3FileSystemConfig setPathStyleAccess(boolean pathStyleAccess) {
        this.pathStyleAccess = pathStyleAccess;
        return this;
    }

    public String getIamRole() {
        return this.iamRole;
    }

    @Config(value="s3.iam-role")
    @ConfigDescription(value="ARN of an IAM role to assume when connecting to S3")
    public S3FileSystemConfig setIamRole(String iamRole) {
        this.iamRole = iamRole;
        return this;
    }

    @NotNull
    public String getRoleSessionName() {
        return this.roleSessionName;
    }

    @Config(value="s3.role-session-name")
    @ConfigDescription(value="Role session name to use when connecting to S3")
    public S3FileSystemConfig setRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
        return this;
    }

    public String getExternalId() {
        return this.externalId;
    }

    @Config(value="s3.external-id")
    @ConfigDescription(value="External ID for the IAM role trust policy when connecting to S3")
    public S3FileSystemConfig setExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    public String getStsEndpoint() {
        return this.stsEndpoint;
    }

    @Config(value="s3.sts.endpoint")
    public S3FileSystemConfig setStsEndpoint(String stsEndpoint) {
        this.stsEndpoint = stsEndpoint;
        return this;
    }

    public String getStsRegion() {
        return this.stsRegion;
    }

    @Config(value="s3.sts.region")
    public S3FileSystemConfig setStsRegion(String stsRegion) {
        this.stsRegion = stsRegion;
        return this;
    }

    @NotNull
    public S3SseType getSseType() {
        return this.sseType;
    }

    @Config(value="s3.sse.type")
    public S3FileSystemConfig setSseType(S3SseType sseType) {
        this.sseType = sseType;
        return this;
    }

    public String getSseKmsKeyId() {
        return this.sseKmsKeyId;
    }

    @Config(value="s3.sse.kms-key-id")
    @ConfigDescription(value="KMS Key ID to use for S3 server-side encryption with KMS-managed key")
    public S3FileSystemConfig setSseKmsKeyId(String sseKmsKeyId) {
        this.sseKmsKeyId = sseKmsKeyId;
        return this;
    }

    @NotNull
    @MinDataSize(value="5MB")
    @MaxDataSize(value="256MB")
    public @NotNull @MinDataSize(value="5MB") @MaxDataSize(value="256MB") DataSize getStreamingPartSize() {
        return this.streamingPartSize;
    }

    @Config(value="s3.streaming.part-size")
    @ConfigDescription(value="Part size for S3 streaming upload")
    public S3FileSystemConfig setStreamingPartSize(DataSize streamingPartSize) {
        this.streamingPartSize = streamingPartSize;
        return this;
    }

    public boolean isRequesterPays() {
        return this.requesterPays;
    }

    @Config(value="s3.requester-pays")
    public S3FileSystemConfig setRequesterPays(boolean requesterPays) {
        this.requesterPays = requesterPays;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getMaxConnections() {
        return this.maxConnections;
    }

    @Config(value="s3.max-connections")
    public S3FileSystemConfig setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public HostAndPort getHttpProxy() {
        return this.httpProxy;
    }

    @Config(value="s3.http-proxy")
    public S3FileSystemConfig setHttpProxy(HostAndPort httpProxy) {
        this.httpProxy = httpProxy;
        return this;
    }

    public boolean isHttpProxySecure() {
        return this.httpProxySecure;
    }

    @Config(value="s3.http-proxy.secure")
    public S3FileSystemConfig setHttpProxySecure(boolean httpProxySecure) {
        this.httpProxySecure = httpProxySecure;
        return this;
    }

    public static enum S3SseType {
        NONE,
        S3,
        KMS;

    }
}

