/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.common.base.Preconditions;
import io.trino.filesystem.Location;
import java.util.Objects;
import java.util.Set;

record S3Location(Location location) {
    S3Location {
        Objects.requireNonNull(location, "location is null");
        Preconditions.checkArgument((boolean)location.scheme().isPresent(), (String)"No scheme for S3 location: %s", (Object)location);
        Preconditions.checkArgument((boolean)Set.of("s3", "s3a", "s3n").contains(location.scheme().get()), (String)"Wrong scheme for S3 location: %s", (Object)location);
        Preconditions.checkArgument((boolean)location.host().isPresent(), (String)"No bucket for S3 location: %s", (Object)location);
        Preconditions.checkArgument((boolean)location.userInfo().isEmpty(), (String)"S3 location contains user info: %s", (Object)location);
        Preconditions.checkArgument((boolean)location.port().isEmpty(), (String)"S3 location contains port: %s", (Object)location);
    }

    public String scheme() {
        return (String)this.location.scheme().orElseThrow();
    }

    public String bucket() {
        return (String)this.location.host().orElseThrow();
    }

    public String key() {
        return this.location.path();
    }

    @Override
    public String toString() {
        return this.location.toString();
    }
}

