/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.s3.S3Context;
import io.trino.filesystem.s3.S3FileIterator;
import io.trino.filesystem.s3.S3InputFile;
import io.trino.filesystem.s3.S3Location;
import io.trino.filesystem.s3.S3OutputFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.model.ObjectIdentifier;
import software.amazon.awssdk.services.s3.model.RequestPayer;
import software.amazon.awssdk.services.s3.model.S3Error;
import software.amazon.awssdk.services.s3.model.S3Object;

final class S3FileSystem
implements TrinoFileSystem {
    private final S3Client client;
    private final S3Context context;
    private final RequestPayer requestPayer;

    public S3FileSystem(S3Client client, S3Context context) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.context = Objects.requireNonNull(context, "context is null");
        this.requestPayer = context.requestPayer();
    }

    public TrinoInputFile newInputFile(Location location) {
        return new S3InputFile(this.client, this.context, new S3Location(location), null);
    }

    public TrinoInputFile newInputFile(Location location, long length) {
        return new S3InputFile(this.client, this.context, new S3Location(location), length);
    }

    public TrinoOutputFile newOutputFile(Location location) {
        return new S3OutputFile(this.client, this.context, new S3Location(location));
    }

    public void deleteFile(Location location) throws IOException {
        location.verifyValidFileLocation();
        S3Location s3Location = new S3Location(location);
        DeleteObjectRequest request = (DeleteObjectRequest)DeleteObjectRequest.builder().overrideConfiguration(this.context::applyCredentialProviderOverride).requestPayer(this.requestPayer).key(s3Location.key()).bucket(s3Location.bucket()).build();
        try {
            this.client.deleteObject(request);
        }
        catch (SdkException e) {
            throw new IOException("Failed to delete file: " + String.valueOf(location), e);
        }
    }

    public void deleteDirectory(Location location) throws IOException {
        FileIterator iterator = this.listFiles(location);
        while (iterator.hasNext()) {
            ArrayList<Location> files = new ArrayList<Location>();
            while (files.size() < 1000 && iterator.hasNext()) {
                files.add(iterator.next().location());
            }
            this.deleteFiles(files);
        }
    }

    public void deleteFiles(Collection<Location> locations) throws IOException {
        locations.forEach(Location::verifyValidFileLocation);
        SetMultimap bucketToKeys = (SetMultimap)locations.stream().map(S3Location::new).collect(Multimaps.toMultimap(S3Location::bucket, S3Location::key, HashMultimap::create));
        HashMap<String, String> failures = new HashMap<String, String>();
        for (Map.Entry entry : bucketToKeys.asMap().entrySet()) {
            String bucket = (String)entry.getKey();
            Collection allKeys = (Collection)entry.getValue();
            for (List keys : Iterables.partition((Iterable)allKeys, (int)250)) {
                List<ObjectIdentifier> objects = keys.stream().map(key -> (ObjectIdentifier)ObjectIdentifier.builder().key(key).build()).toList();
                DeleteObjectsRequest request = (DeleteObjectsRequest)DeleteObjectsRequest.builder().overrideConfiguration(this.context::applyCredentialProviderOverride).requestPayer(this.requestPayer).bucket(bucket).delete(builder -> builder.objects((Collection)objects).quiet(Boolean.valueOf(true))).build();
                try {
                    DeleteObjectsResponse response = this.client.deleteObjects(request);
                    for (S3Error error : response.errors()) {
                        failures.put("s3://%s/%s".formatted(bucket, error.key()), error.code());
                    }
                }
                catch (SdkException e) {
                    throw new IOException("Error while batch deleting files", e);
                }
            }
        }
        if (!failures.isEmpty()) {
            throw new IOException("Failed to delete one or more files: " + String.valueOf(failures));
        }
    }

    public void renameFile(Location source, Location target) throws IOException {
        throw new IOException("S3 does not support renames");
    }

    public FileIterator listFiles(Location location) throws IOException {
        S3Location s3Location = new S3Location(location);
        Object key = s3Location.key();
        if (!((String)key).isEmpty() && !((String)key).endsWith("/")) {
            key = (String)key + "/";
        }
        ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().overrideConfiguration(this.context::applyCredentialProviderOverride).bucket(s3Location.bucket()).prefix((String)key).build();
        try {
            Iterator<S3Object> iterator = this.client.listObjectsV2Paginator(request).contents().stream().filter(object -> !object.key().endsWith("/")).iterator();
            return new S3FileIterator(s3Location, iterator);
        }
        catch (SdkException e) {
            throw new IOException("Failed to list location: " + String.valueOf(location), e);
        }
    }

    public Optional<Boolean> directoryExists(Location location) throws IOException {
        S3FileSystem.validateS3Location(location);
        if (location.path().isEmpty() || this.listFiles(location).hasNext()) {
            return Optional.of(true);
        }
        return Optional.empty();
    }

    public void createDirectory(Location location) {
        S3FileSystem.validateS3Location(location);
    }

    public void renameDirectory(Location source, Location target) throws IOException {
        throw new IOException("S3 does not support directory renames");
    }

    public Set<Location> listDirectories(Location location) throws IOException {
        S3Location s3Location = new S3Location(location);
        Location baseLocation = s3Location.baseLocation();
        Object key = s3Location.key();
        if (!((String)key).isEmpty() && !((String)key).endsWith("/")) {
            key = (String)key + "/";
        }
        ListObjectsV2Request request = (ListObjectsV2Request)ListObjectsV2Request.builder().overrideConfiguration(this.context::applyCredentialProviderOverride).bucket(s3Location.bucket()).prefix((String)key).delimiter("/").build();
        try {
            return (Set)this.client.listObjectsV2Paginator(request).commonPrefixes().stream().map(CommonPrefix::prefix).map(arg_0 -> ((Location)baseLocation).appendPath(arg_0)).collect(ImmutableSet.toImmutableSet());
        }
        catch (SdkException e) {
            throw new IOException("Failed to list location: " + String.valueOf(location), e);
        }
    }

    public Optional<Location> createTemporaryDirectory(Location targetPath, String temporaryPrefix, String relativePrefix) {
        S3FileSystem.validateS3Location(targetPath);
        return Optional.empty();
    }

    private static void validateS3Location(Location location) {
        new S3Location(location);
    }
}

