/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.Objects;
import software.amazon.awssdk.core.exception.AbortedException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;

final class S3Input
implements TrinoInput {
    private final Location location;
    private final S3Client client;
    private final GetObjectRequest request;
    private boolean closed;

    public S3Input(Location location, S3Client client, GetObjectRequest request) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.client = Objects.requireNonNull(client, "client is null");
        this.request = Objects.requireNonNull(request, "request is null");
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        this.ensureOpen();
        if (position < 0L) {
            throw new IOException("Negative seek offset");
        }
        Objects.checkFromIndexSize(offset, length, buffer.length);
        if (length == 0) {
            return;
        }
        String range = "bytes=%s-%s".formatted(position, position + (long)length - 1L);
        GetObjectRequest rangeRequest = (GetObjectRequest)this.request.toBuilder().range(range).build();
        try (InputStream in = this.getObject(rangeRequest);){
            int n = S3Input.readNBytes(in, buffer, offset, length);
            if (n < length) {
                throw new EOFException("Read %s of %s requested bytes: %s".formatted(n, length, this.location));
            }
        }
    }

    public int readTail(byte[] buffer, int offset, int length) throws IOException {
        this.ensureOpen();
        Objects.checkFromIndexSize(offset, length, buffer.length);
        if (length == 0) {
            return 0;
        }
        String range = "bytes=-%s".formatted(length);
        GetObjectRequest rangeRequest = (GetObjectRequest)this.request.toBuilder().range(range).build();
        try (InputStream in = this.getObject(rangeRequest);){
            int n = S3Input.readNBytes(in, buffer, offset, length);
            return n;
        }
    }

    public void close() {
        this.closed = true;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Input closed: " + String.valueOf(this.location));
        }
    }

    private InputStream getObject(GetObjectRequest request) throws IOException {
        try {
            return this.client.getObject(request);
        }
        catch (NoSuchKeyException e) {
            throw new FileNotFoundException(this.location.toString());
        }
        catch (SdkException e) {
            throw new IOException("Failed to open S3 file: " + String.valueOf(this.location), e);
        }
    }

    private static int readNBytes(InputStream in, byte[] buffer, int offset, int length) throws IOException {
        try {
            return in.readNBytes(buffer, offset, length);
        }
        catch (AbortedException e) {
            throw new InterruptedIOException();
        }
    }
}

