/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.HostAndPort;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import java.util.Set;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;

public class S3FileSystemConfig {
    private String awsAccessKey;
    private String awsSecretKey;
    private String endpoint;
    private String region;
    private boolean pathStyleAccess;
    private String iamRole;
    private String roleSessionName = "trino-filesystem";
    private String externalId;
    private String stsEndpoint;
    private String stsRegion;
    private S3SseType sseType = S3SseType.NONE;
    private String sseKmsKeyId;
    private boolean useWebIdentityTokenCredentialsProvider;
    private DataSize streamingPartSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private boolean requesterPays;
    private Integer maxConnections = 500;
    private Duration connectionTtl;
    private Duration connectionMaxIdleTime;
    private Duration socketConnectTimeout;
    private Duration socketReadTimeout;
    private boolean tcpKeepAlive;
    private HostAndPort httpProxy;
    private boolean httpProxySecure;
    private String httpProxyUsername;
    private String httpProxyPassword;
    private boolean preemptiveBasicProxyAuth;
    private Set<String> nonProxyHosts = ImmutableSet.of();
    private ObjectCannedAcl objectCannedAcl = ObjectCannedAcl.NONE;
    private RetryMode retryMode = RetryMode.LEGACY;
    private int maxErrorRetries = 10;

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    @Config(value="s3.aws-access-key")
    public S3FileSystemConfig setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
        return this;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    @Config(value="s3.aws-secret-key")
    @ConfigSecuritySensitive
    public S3FileSystemConfig setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @Config(value="s3.endpoint")
    public S3FileSystemConfig setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    @Config(value="s3.region")
    public S3FileSystemConfig setRegion(String region) {
        this.region = region;
        return this;
    }

    public boolean isPathStyleAccess() {
        return this.pathStyleAccess;
    }

    @Config(value="s3.path-style-access")
    @ConfigDescription(value="Use path-style access for all requests to S3")
    public S3FileSystemConfig setPathStyleAccess(boolean pathStyleAccess) {
        this.pathStyleAccess = pathStyleAccess;
        return this;
    }

    public String getIamRole() {
        return this.iamRole;
    }

    @Config(value="s3.iam-role")
    @ConfigDescription(value="ARN of an IAM role to assume when connecting to S3")
    public S3FileSystemConfig setIamRole(String iamRole) {
        this.iamRole = iamRole;
        return this;
    }

    @NotNull
    public String getRoleSessionName() {
        return this.roleSessionName;
    }

    @Config(value="s3.role-session-name")
    @ConfigDescription(value="Role session name to use when connecting to S3")
    public S3FileSystemConfig setRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
        return this;
    }

    public String getExternalId() {
        return this.externalId;
    }

    @Config(value="s3.external-id")
    @ConfigDescription(value="External ID for the IAM role trust policy when connecting to S3")
    public S3FileSystemConfig setExternalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    public String getStsEndpoint() {
        return this.stsEndpoint;
    }

    @Config(value="s3.sts.endpoint")
    public S3FileSystemConfig setStsEndpoint(String stsEndpoint) {
        this.stsEndpoint = stsEndpoint;
        return this;
    }

    public String getStsRegion() {
        return this.stsRegion;
    }

    @Config(value="s3.sts.region")
    public S3FileSystemConfig setStsRegion(String stsRegion) {
        this.stsRegion = stsRegion;
        return this;
    }

    @NotNull
    public ObjectCannedAcl getCannedAcl() {
        return this.objectCannedAcl;
    }

    @Config(value="s3.canned-acl")
    @ConfigDescription(value="Canned ACL (predefined grants) to manage access to objects")
    public S3FileSystemConfig setCannedAcl(ObjectCannedAcl objectCannedAcl) {
        this.objectCannedAcl = objectCannedAcl;
        return this;
    }

    public RetryMode getRetryMode() {
        return this.retryMode;
    }

    @Config(value="s3.retry-mode")
    @ConfigDescription(value="Specifies how the AWS SDK attempts retries, default is LEGACY")
    public S3FileSystemConfig setRetryMode(RetryMode retryMode) {
        this.retryMode = retryMode;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxErrorRetries() {
        return this.maxErrorRetries;
    }

    @Config(value="s3.max-error-retries")
    public S3FileSystemConfig setMaxErrorRetries(int maxErrorRetries) {
        this.maxErrorRetries = maxErrorRetries;
        return this;
    }

    @NotNull
    public S3SseType getSseType() {
        return this.sseType;
    }

    @Config(value="s3.sse.type")
    public S3FileSystemConfig setSseType(S3SseType sseType) {
        this.sseType = sseType;
        return this;
    }

    public String getSseKmsKeyId() {
        return this.sseKmsKeyId;
    }

    @Config(value="s3.sse.kms-key-id")
    @ConfigDescription(value="KMS Key ID to use for S3 server-side encryption with KMS-managed key")
    public S3FileSystemConfig setSseKmsKeyId(String sseKmsKeyId) {
        this.sseKmsKeyId = sseKmsKeyId;
        return this;
    }

    public boolean isUseWebIdentityTokenCredentialsProvider() {
        return this.useWebIdentityTokenCredentialsProvider;
    }

    @Config(value="s3.use-web-identity-token-credentials-provider")
    public S3FileSystemConfig setUseWebIdentityTokenCredentialsProvider(boolean useWebIdentityTokenCredentialsProvider) {
        this.useWebIdentityTokenCredentialsProvider = useWebIdentityTokenCredentialsProvider;
        return this;
    }

    @NotNull
    @MinDataSize(value="5MB")
    @MaxDataSize(value="256MB")
    public @NotNull @MinDataSize(value="5MB") @MaxDataSize(value="256MB") DataSize getStreamingPartSize() {
        return this.streamingPartSize;
    }

    @Config(value="s3.streaming.part-size")
    @ConfigDescription(value="Part size for S3 streaming upload")
    public S3FileSystemConfig setStreamingPartSize(DataSize streamingPartSize) {
        this.streamingPartSize = streamingPartSize;
        return this;
    }

    public boolean isRequesterPays() {
        return this.requesterPays;
    }

    @Config(value="s3.requester-pays")
    public S3FileSystemConfig setRequesterPays(boolean requesterPays) {
        this.requesterPays = requesterPays;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getMaxConnections() {
        return this.maxConnections;
    }

    @Config(value="s3.max-connections")
    public S3FileSystemConfig setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public Optional<Duration> getConnectionTtl() {
        return Optional.ofNullable(this.connectionTtl);
    }

    @Config(value="s3.connection-ttl")
    @ConfigDescription(value="Maximum time allowed for connections to be reused before being replaced in the connection pool")
    public S3FileSystemConfig setConnectionTtl(Duration connectionTtl) {
        this.connectionTtl = connectionTtl;
        return this;
    }

    public Optional<Duration> getConnectionMaxIdleTime() {
        return Optional.ofNullable(this.connectionMaxIdleTime);
    }

    @Config(value="s3.connection-max-idle-time")
    @ConfigDescription(value="Maximum time allowed for connections to remain idle in the connection pool before being closed")
    public S3FileSystemConfig setConnectionMaxIdleTime(Duration connectionMaxIdleTime) {
        this.connectionMaxIdleTime = connectionMaxIdleTime;
        return this;
    }

    public Optional<Duration> getSocketConnectTimeout() {
        return Optional.ofNullable(this.socketConnectTimeout);
    }

    @Config(value="s3.socket-connect-timeout")
    @ConfigDescription(value="Maximum time allowed for socket connect to complete before timing out")
    public S3FileSystemConfig setSocketConnectTimeout(Duration socketConnectTimeout) {
        this.socketConnectTimeout = socketConnectTimeout;
        return this;
    }

    public Optional<Duration> getSocketReadTimeout() {
        return Optional.ofNullable(this.socketReadTimeout);
    }

    @Config(value="s3.socket-read-timeout")
    @ConfigDescription(value="Maximum time allowed for socket reads before timing out")
    public S3FileSystemConfig setSocketReadTimeout(Duration socketReadTimeout) {
        this.socketReadTimeout = socketReadTimeout;
        return this;
    }

    public boolean getTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    @Config(value="s3.tcp-keep-alive")
    @ConfigDescription(value="Enable TCP keep alive on created connections")
    public S3FileSystemConfig setTcpKeepAlive(boolean tcpKeepAlive) {
        this.tcpKeepAlive = tcpKeepAlive;
        return this;
    }

    public HostAndPort getHttpProxy() {
        return this.httpProxy;
    }

    @Config(value="s3.http-proxy")
    public S3FileSystemConfig setHttpProxy(HostAndPort httpProxy) {
        this.httpProxy = httpProxy;
        return this;
    }

    public boolean isHttpProxySecure() {
        return this.httpProxySecure;
    }

    @Config(value="s3.http-proxy.secure")
    public S3FileSystemConfig setHttpProxySecure(boolean httpProxySecure) {
        this.httpProxySecure = httpProxySecure;
        return this;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    @Config(value="s3.http-proxy.username")
    public S3FileSystemConfig setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
        return this;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    @Config(value="s3.http-proxy.password")
    @ConfigSecuritySensitive
    public S3FileSystemConfig setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
        return this;
    }

    public boolean getHttpProxyPreemptiveBasicProxyAuth() {
        return this.preemptiveBasicProxyAuth;
    }

    @Config(value="s3.http-proxy.preemptive-basic-auth")
    public S3FileSystemConfig setHttpProxyPreemptiveBasicProxyAuth(boolean preemptiveBasicProxyAuth) {
        this.preemptiveBasicProxyAuth = preemptiveBasicProxyAuth;
        return this;
    }

    public Set<String> getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    @Config(value="s3.http-proxy.non-proxy-hosts")
    public S3FileSystemConfig setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = ImmutableSet.copyOf((Iterable)Splitter.on((char)',').omitEmptyStrings().trimResults().split((CharSequence)Strings.nullToEmpty((String)nonProxyHosts)));
        return this;
    }

    public static enum S3SseType {
        NONE,
        S3,
        KMS;

    }

    public static enum ObjectCannedAcl {
        NONE,
        PRIVATE,
        PUBLIC_READ,
        PUBLIC_READ_WRITE,
        AUTHENTICATED_READ,
        BUCKET_OWNER_READ,
        BUCKET_OWNER_FULL_CONTROL;


        public static ObjectCannedACL getCannedAcl(ObjectCannedAcl cannedAcl) {
            return switch (cannedAcl.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> null;
                case 1 -> ObjectCannedACL.PRIVATE;
                case 2 -> ObjectCannedACL.PUBLIC_READ;
                case 3 -> ObjectCannedACL.PUBLIC_READ_WRITE;
                case 4 -> ObjectCannedACL.AUTHENTICATED_READ;
                case 5 -> ObjectCannedACL.BUCKET_OWNER_READ;
                case 6 -> ObjectCannedACL.BUCKET_OWNER_FULL_CONTROL;
            };
        }
    }

    public static enum RetryMode {
        STANDARD,
        LEGACY,
        ADAPTIVE;


        public static RetryStrategy getRetryStrategy(RetryMode retryMode) {
            return switch (retryMode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> AwsRetryStrategy.standardRetryStrategy();
                case 1 -> AwsRetryStrategy.legacyRetryStrategy();
                case 2 -> AwsRetryStrategy.adaptiveRetryStrategy();
            };
        }
    }
}

