/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.inject.Inject;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.s3.S3Context;
import io.trino.filesystem.s3.S3FileSystem;
import io.trino.filesystem.s3.S3FileSystemConfig;
import io.trino.filesystem.s3.S3FileSystemLoader;
import io.trino.spi.security.ConnectorIdentity;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.Executor;
import software.amazon.awssdk.services.s3.S3Client;

public final class S3FileSystemFactory
implements TrinoFileSystemFactory {
    private final S3FileSystemLoader loader;
    private final S3Client client;
    private final S3Context context;
    private final Executor uploadExecutor;

    @Inject
    public S3FileSystemFactory(OpenTelemetry openTelemetry, S3FileSystemConfig config) {
        this.loader = new S3FileSystemLoader(openTelemetry, config);
        this.client = this.loader.createClient();
        this.context = this.loader.context();
        this.uploadExecutor = this.loader.uploadExecutor();
    }

    @PreDestroy
    public void destroy() {
        try (S3Client s3Client = this.client;){
            this.loader.destroy();
        }
    }

    public TrinoFileSystem create(ConnectorIdentity identity) {
        return new S3FileSystem(this.uploadExecutor, this.client, this.context.withCredentials(identity));
    }
}

