/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemException;
import io.trino.filesystem.TrinoInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Objects;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.AbortedException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;

final class S3InputStream
extends TrinoInputStream {
    private static final int MAX_SKIP_BYTES = 0x100000;
    private final Location location;
    private final S3Client client;
    private final GetObjectRequest request;
    private final Long length;
    private boolean closed;
    private ResponseInputStream<GetObjectResponse> in;
    private long streamPosition;
    private long nextReadPosition;

    public S3InputStream(Location location, S3Client client, GetObjectRequest request, Long length) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.client = Objects.requireNonNull(client, "client is null");
        this.request = Objects.requireNonNull(request, "request is null");
        this.length = length;
    }

    public int available() throws IOException {
        this.ensureOpen();
        if (this.in != null && this.nextReadPosition == this.streamPosition) {
            return this.getAvailable();
        }
        return 0;
    }

    public long getPosition() {
        return this.nextReadPosition;
    }

    public void seek(long position) throws IOException {
        this.ensureOpen();
        if (position < 0L) {
            throw new IOException("Negative seek offset");
        }
        if (this.length != null && position > this.length) {
            throw new IOException("Cannot seek to %s. File size is %s: %s".formatted(position, this.length, this.location));
        }
        this.nextReadPosition = position;
    }

    public int read() throws IOException {
        this.ensureOpen();
        this.seekStream();
        int value = this.doRead();
        if (value >= 0) {
            ++this.streamPosition;
            ++this.nextReadPosition;
        }
        return value;
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        this.ensureOpen();
        this.seekStream();
        int n = this.doRead(bytes, offset, length);
        if (n > 0) {
            this.streamPosition += (long)n;
            this.nextReadPosition += (long)n;
        }
        return n;
    }

    public long skip(long n) throws IOException {
        this.ensureOpen();
        this.seekStream();
        long skip = this.doSkip(n);
        this.streamPosition += skip;
        this.nextReadPosition += skip;
        return skip;
    }

    public void skipNBytes(long n) throws IOException {
        this.ensureOpen();
        if (n <= 0L) {
            return;
        }
        long position = this.nextReadPosition + n;
        if (position < 0L || this.length != null && position > this.length) {
            throw new EOFException("Unable to skip %s bytes (position=%s, fileSize=%s): %s".formatted(n, this.nextReadPosition, this.length, this.location));
        }
        this.nextReadPosition = position;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closeStream();
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream closed: " + String.valueOf(this.location));
        }
    }

    private void seekStream() throws IOException {
        long skip;
        if (this.in != null && this.nextReadPosition == this.streamPosition) {
            return;
        }
        if (this.in != null && this.nextReadPosition > this.streamPosition && (skip = this.nextReadPosition - this.streamPosition) <= (long)Math.max(this.getAvailable(), 0x100000) && this.doSkip(skip) == skip) {
            this.streamPosition = this.nextReadPosition;
            return;
        }
        this.streamPosition = this.nextReadPosition;
        this.closeStream();
        try {
            GetObjectRequest rangeRequest = this.request;
            if (this.nextReadPosition != 0L) {
                String range = "bytes=%s-".formatted(this.nextReadPosition);
                rangeRequest = (GetObjectRequest)this.request.toBuilder().range(range).build();
            }
            this.in = this.client.getObject(rangeRequest);
            if (((GetObjectResponse)this.in.response()).contentLength() != null && ((GetObjectResponse)this.in.response()).contentLength() == 0L) {
                this.in = new ResponseInputStream((Object)((GetObjectResponse)this.in.response()), S3InputStream.nullInputStream());
            }
            this.streamPosition = this.nextReadPosition;
        }
        catch (NoSuchKeyException e) {
            FileNotFoundException ex = new FileNotFoundException(this.location.toString());
            ex.initCause(e);
            throw ex;
        }
        catch (SdkException e) {
            throw new TrinoFileSystemException("Failed to open S3 file: " + String.valueOf(this.location), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStream() {
        if (this.in == null) {
            return;
        }
        try (ResponseInputStream<GetObjectResponse> responseInputStream = this.in;){
            this.in.abort();
        }
        catch (IOException | AbortedException throwable) {
        }
        finally {
            this.in = null;
        }
    }

    private int getAvailable() throws IOException {
        try {
            return this.in.available();
        }
        catch (AbortedException e) {
            throw new InterruptedIOException();
        }
    }

    private long doSkip(long n) throws IOException {
        try {
            return this.in.skip(n);
        }
        catch (AbortedException e) {
            throw new InterruptedIOException();
        }
    }

    private int doRead() throws IOException {
        try {
            return this.in.read();
        }
        catch (AbortedException e) {
            throw new InterruptedIOException();
        }
    }

    private int doRead(byte[] bytes, int offset, int length) throws IOException {
        try {
            return this.in.read(bytes, offset, length);
        }
        catch (AbortedException e) {
            throw new InterruptedIOException();
        }
    }
}

