/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.s3.S3Context;
import io.trino.filesystem.s3.S3Location;
import io.trino.filesystem.s3.S3OutputStream;
import io.trino.memory.context.AggregatedMemoryContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.Executor;
import software.amazon.awssdk.services.s3.S3Client;

final class S3OutputFile
implements TrinoOutputFile {
    private final Executor uploadExecutor;
    private final S3Client client;
    private final S3Context context;
    private final S3Location location;

    public S3OutputFile(Executor uploadExecutor, S3Client client, S3Context context, S3Location location) {
        this.uploadExecutor = Objects.requireNonNull(uploadExecutor, "uploadExecutor is null");
        this.client = Objects.requireNonNull(client, "client is null");
        this.context = Objects.requireNonNull(context, "context is null");
        this.location = Objects.requireNonNull(location, "location is null");
        location.location().verifyValidFileLocation();
    }

    public void createOrOverwrite(byte[] data) throws IOException {
        try (OutputStream out = this.create();){
            out.write(data);
        }
    }

    public OutputStream create(AggregatedMemoryContext memoryContext) {
        return new S3OutputStream(memoryContext, this.uploadExecutor, this.client, this.context, this.location);
    }

    public Location location() {
        return this.location.location();
    }
}

