/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.s3.S3Context;
import io.trino.filesystem.s3.S3FileSystem;
import io.trino.filesystem.s3.S3FileSystemLoader;
import io.trino.filesystem.s3.S3SecurityMappingProvider;
import io.trino.filesystem.s3.S3SecurityMappingResult;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import software.amazon.awssdk.services.s3.S3Client;

final class S3SecurityMappingFileSystemFactory
implements TrinoFileSystemFactory {
    private final S3SecurityMappingProvider mappingProvider;
    private final S3FileSystemLoader.S3ClientFactory clientFactory;
    private final S3Context context;
    private final Location location;
    private final Executor uploadExecutor;
    private final Map<Optional<S3SecurityMappingResult>, S3Client> clients = new ConcurrentHashMap<Optional<S3SecurityMappingResult>, S3Client>();

    public S3SecurityMappingFileSystemFactory(S3SecurityMappingProvider mappingProvider, S3FileSystemLoader.S3ClientFactory clientFactory, S3Context context, Location location, Executor uploadExecutor) {
        this.mappingProvider = Objects.requireNonNull(mappingProvider, "mappingProvider is null");
        this.uploadExecutor = Objects.requireNonNull(uploadExecutor, "uploadExecutor is null");
        this.clientFactory = Objects.requireNonNull(clientFactory, "clientFactory is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.context = Objects.requireNonNull(context, "context is null");
    }

    public TrinoFileSystem create(ConnectorIdentity identity) {
        Optional<S3SecurityMappingResult> mapping = this.mappingProvider.getMapping(identity, this.location);
        S3Client client = this.clients.computeIfAbsent(mapping, optional -> this.clientFactory.create(mapping));
        S3Context context = this.context.withCredentials(identity);
        if (mapping.isPresent() && mapping.get().kmsKeyId().isPresent()) {
            context = context.withKmsKeyId(mapping.get().kmsKeyId().get());
        }
        return new S3FileSystem(this.uploadExecutor, client, context);
    }
}

