/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.common.base.Preconditions;
import io.trino.filesystem.s3.S3FileSystemConfig;
import io.trino.filesystem.s3.S3SseCustomerKey;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.s3.model.RequestPayer;

record S3Context(int partSize, boolean requesterPays, S3SseContext s3SseContext, Optional<AwsCredentialsProvider> credentialsProviderOverride, S3FileSystemConfig.ObjectCannedAcl cannedAcl, boolean exclusiveWriteSupported) {
    private static final int MIN_PART_SIZE = 0x500000;

    public S3Context {
        Preconditions.checkArgument((partSize >= 0x500000 ? 1 : 0) != 0, (String)"partSize must be at least %s bytes", (int)0x500000);
        Objects.requireNonNull(s3SseContext, "sseContext is null");
        Objects.requireNonNull(credentialsProviderOverride, "credentialsProviderOverride is null");
    }

    public RequestPayer requestPayer() {
        return this.requesterPays ? RequestPayer.REQUESTER : null;
    }

    public S3Context withKmsKeyId(String kmsKeyId) {
        return new S3Context(this.partSize, this.requesterPays, S3SseContext.withKmsKeyId(kmsKeyId), this.credentialsProviderOverride, this.cannedAcl, this.exclusiveWriteSupported);
    }

    public S3Context withCredentials(ConnectorIdentity identity) {
        if (identity.getExtraCredentials().containsKey("internal$s3_aws_access_key")) {
            StaticCredentialsProvider credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)((String)identity.getExtraCredentials().get("internal$s3_aws_access_key")), (String)((String)identity.getExtraCredentials().get("internal$s3_aws_secret_key")), (String)((String)identity.getExtraCredentials().get("internal$s3_aws_session_token"))));
            return this.withCredentialsProviderOverride((AwsCredentialsProvider)credentialsProvider);
        }
        return this;
    }

    public S3Context withCredentialsProviderOverride(AwsCredentialsProvider credentialsProviderOverride) {
        return new S3Context(this.partSize, this.requesterPays, this.s3SseContext, Optional.of(credentialsProviderOverride), this.cannedAcl, this.exclusiveWriteSupported);
    }

    public void applyCredentialProviderOverride(AwsRequestOverrideConfiguration.Builder builder) {
        this.credentialsProviderOverride.ifPresent(arg_0 -> ((AwsRequestOverrideConfiguration.Builder)builder).credentialsProvider(arg_0));
    }

    record S3SseContext(S3FileSystemConfig.S3SseType sseType, Optional<String> sseKmsKeyId, Optional<S3SseCustomerKey> sseCustomerKey) {
        S3SseContext {
            Objects.requireNonNull(sseType, "sseType is null");
            Objects.requireNonNull(sseKmsKeyId, "sseKmsKeyId is null");
            Objects.requireNonNull(sseCustomerKey, "sseCustomerKey is null");
            switch (sseType) {
                case KMS: {
                    Preconditions.checkArgument((boolean)sseKmsKeyId.isPresent(), (Object)"sseKmsKeyId is missing for SSE-KMS");
                    break;
                }
                case CUSTOMER: {
                    Preconditions.checkArgument((boolean)sseCustomerKey.isPresent(), (Object)"sseCustomerKey is missing for SSE-C");
                    break;
                }
            }
        }

        public static S3SseContext of(S3FileSystemConfig.S3SseType sseType, String sseKmsKeyId, String sseCustomerKey) {
            return new S3SseContext(sseType, Optional.ofNullable(sseKmsKeyId), Optional.ofNullable(sseCustomerKey).map(S3SseCustomerKey::onAes256));
        }

        public static S3SseContext withKmsKeyId(String kmsKeyId) {
            return new S3SseContext(S3FileSystemConfig.S3SseType.KMS, Optional.ofNullable(kmsKeyId), Optional.empty());
        }
    }
}

