/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.stats.CounterStat;
import io.airlift.stats.TimeStat;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class AwsSdkV2ApiCallStats {
    private final TimeStat latency = new TimeStat(TimeUnit.MILLISECONDS);
    private final CounterStat calls = new CounterStat();
    private final CounterStat failures = new CounterStat();
    private final CounterStat retries = new CounterStat();
    private final CounterStat throttlingExceptions = new CounterStat();
    private final CounterStat serverErrors = new CounterStat();

    @Managed
    @Nested
    public TimeStat getLatency() {
        return this.latency;
    }

    @Managed
    @Nested
    public CounterStat getCalls() {
        return this.calls;
    }

    @Managed
    @Nested
    public CounterStat getFailures() {
        return this.failures;
    }

    @Managed
    @Nested
    public CounterStat getRetries() {
        return this.retries;
    }

    @Managed
    @Nested
    public CounterStat getThrottlingExceptions() {
        return this.throttlingExceptions;
    }

    @Managed
    @Nested
    public CounterStat getServerErrors() {
        return this.serverErrors;
    }

    public void updateLatency(Duration duration) {
        this.latency.addNanos(duration.toNanos());
    }

    public void updateCalls() {
        this.calls.update(1L);
    }

    public void updateFailures() {
        this.failures.update(1L);
    }

    public void updateRetries(int retryCount) {
        this.retries.update((long)retryCount);
    }

    public void updateThrottlingExceptions() {
        this.throttlingExceptions.update(1L);
    }

    public void updateServerErrors() {
        this.serverErrors.update(1L);
    }
}

