/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import com.google.common.base.Verify;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemException;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.encryption.EncryptionKey;
import io.trino.filesystem.s3.S3Context;
import io.trino.filesystem.s3.S3FileSystemConfig;
import io.trino.filesystem.s3.S3Input;
import io.trino.filesystem.s3.S3InputStream;
import io.trino.filesystem.s3.S3Location;
import io.trino.filesystem.s3.S3SseCUtils;
import io.trino.filesystem.s3.S3SseRequestConfigurator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.RequestPayer;

final class S3InputFile
implements TrinoInputFile {
    private final S3Client client;
    private final S3Location location;
    private final S3Context context;
    private final RequestPayer requestPayer;
    private final Optional<EncryptionKey> key;
    private Long length;
    private Instant lastModified;

    public S3InputFile(S3Client client, S3Context context, S3Location location, Long length, Instant lastModified, Optional<EncryptionKey> key) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.context = Objects.requireNonNull(context, "context is null");
        this.requestPayer = context.requestPayer();
        this.length = length;
        this.lastModified = lastModified;
        this.key = Objects.requireNonNull(key, "key is null");
        location.location().verifyValidFileLocation();
        Verify.verify((key.isEmpty() || context.s3SseContext().sseType() == S3FileSystemConfig.S3SseType.NONE ? 1 : 0) != 0, (String)"Encryption key cannot be used with SSE configuration", (Object[])new Object[0]);
    }

    public TrinoInput newInput() {
        return new S3Input(this.location(), this.client, this.newGetObjectRequest());
    }

    public TrinoInputStream newStream() {
        return new S3InputStream(this.location(), this.client, this.newGetObjectRequest(), this.length);
    }

    public long length() throws IOException {
        if (this.length == null && !this.headObject()) {
            throw new FileNotFoundException(this.location.toString());
        }
        return this.length;
    }

    public Instant lastModified() throws IOException {
        if (this.lastModified == null && !this.headObject()) {
            throw new FileNotFoundException(this.location.toString());
        }
        return this.lastModified;
    }

    public boolean exists() throws IOException {
        return this.headObject();
    }

    public Location location() {
        return this.location.location();
    }

    private GetObjectRequest newGetObjectRequest() {
        return (GetObjectRequest)((GetObjectRequest.Builder)GetObjectRequest.builder().overrideConfiguration(this.context::applyCredentialProviderOverride).requestPayer(this.requestPayer).bucket(this.location.bucket()).key(this.location.key()).applyMutation(builder -> this.key.ifPresentOrElse(encryption -> builder.sseCustomerKey(S3SseCUtils.encoded(encryption)).sseCustomerAlgorithm(encryption.algorithm()).sseCustomerKeyMD5(S3SseCUtils.md5Checksum(encryption)), () -> S3SseRequestConfigurator.setEncryptionSettings(builder, this.context.s3SseContext())))).build();
    }

    private boolean headObject() throws IOException {
        HeadObjectRequest request = (HeadObjectRequest)((HeadObjectRequest.Builder)HeadObjectRequest.builder().overrideConfiguration(this.context::applyCredentialProviderOverride).requestPayer(this.requestPayer).bucket(this.location.bucket()).key(this.location.key()).applyMutation(builder -> this.key.ifPresentOrElse(encryption -> builder.sseCustomerKey(S3SseCUtils.encoded(encryption)).sseCustomerAlgorithm(encryption.algorithm()).sseCustomerKeyMD5(S3SseCUtils.md5Checksum(encryption)), () -> S3SseRequestConfigurator.setEncryptionSettings(builder, this.context.s3SseContext())))).build();
        try {
            HeadObjectResponse response = this.client.headObject(request);
            if (this.length == null) {
                this.length = response.contentLength();
            }
            if (this.lastModified == null) {
                this.lastModified = response.lastModified();
            }
            return true;
        }
        catch (NoSuchKeyException e) {
            return false;
        }
        catch (SdkException e) {
            throw new TrinoFileSystemException("S3 HEAD request failed for file: " + String.valueOf(this.location), (Throwable)e);
        }
    }
}

