/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import io.trino.filesystem.s3.S3Context;
import io.trino.filesystem.s3.S3FileSystemConfig;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

public final class S3SseRequestConfigurator {
    private S3SseRequestConfigurator() {
    }

    public static void setEncryptionSettings(PutObjectRequest.Builder builder, S3Context.S3SseContext context) {
        switch (context.sseType()) {
            case NONE: {
                break;
            }
            case S3: {
                builder.serverSideEncryption(ServerSideEncryption.AES256);
                break;
            }
            case KMS: {
                context.sseKmsKeyId().ifPresent(arg_0 -> ((PutObjectRequest.Builder)builder.serverSideEncryption(ServerSideEncryption.AWS_KMS)).ssekmsKeyId(arg_0));
                break;
            }
            case CUSTOMER: {
                context.sseCustomerKey().ifPresent(s3SseCustomerKey -> builder.sseCustomerAlgorithm(s3SseCustomerKey.algorithm()).sseCustomerKey(s3SseCustomerKey.key()).sseCustomerKeyMD5(s3SseCustomerKey.md5()));
            }
        }
    }

    public static void setEncryptionSettings(CreateMultipartUploadRequest.Builder builder, S3Context.S3SseContext context) {
        switch (context.sseType()) {
            case NONE: {
                break;
            }
            case S3: {
                builder.serverSideEncryption(ServerSideEncryption.AES256);
                break;
            }
            case KMS: {
                context.sseKmsKeyId().ifPresent(arg_0 -> ((CreateMultipartUploadRequest.Builder)builder.serverSideEncryption(ServerSideEncryption.AWS_KMS)).ssekmsKeyId(arg_0));
                break;
            }
            case CUSTOMER: {
                context.sseCustomerKey().ifPresent(s3SseCustomerKey -> builder.sseCustomerAlgorithm(s3SseCustomerKey.algorithm()).sseCustomerKey(s3SseCustomerKey.key()).sseCustomerKeyMD5(s3SseCustomerKey.md5()));
            }
        }
    }

    public static void setEncryptionSettings(CompleteMultipartUploadRequest.Builder builder, S3Context.S3SseContext context) {
        if (context.sseType() == S3FileSystemConfig.S3SseType.CUSTOMER) {
            context.sseCustomerKey().ifPresent(s3SseCustomerKey -> builder.sseCustomerAlgorithm(s3SseCustomerKey.algorithm()).sseCustomerKey(s3SseCustomerKey.key()).sseCustomerKeyMD5(s3SseCustomerKey.md5()));
        }
    }

    public static void setEncryptionSettings(GetObjectRequest.Builder builder, S3Context.S3SseContext context) {
        if (context.sseType().equals((Object)S3FileSystemConfig.S3SseType.CUSTOMER)) {
            context.sseCustomerKey().ifPresent(s3SseCustomerKey -> builder.sseCustomerAlgorithm(s3SseCustomerKey.algorithm()).sseCustomerKey(s3SseCustomerKey.key()).sseCustomerKeyMD5(s3SseCustomerKey.md5()));
        }
    }

    public static void setEncryptionSettings(HeadObjectRequest.Builder builder, S3Context.S3SseContext context) {
        if (context.sseType().equals((Object)S3FileSystemConfig.S3SseType.CUSTOMER)) {
            context.sseCustomerKey().ifPresent(s3SseCustomerKey -> builder.sseCustomerAlgorithm(s3SseCustomerKey.algorithm()).sseCustomerKey(s3SseCustomerKey.key()).sseCustomerKeyMD5(s3SseCustomerKey.md5()));
        }
    }

    public static void setEncryptionSettings(UploadPartRequest.Builder builder, S3Context.S3SseContext context) {
        if (context.sseType() == S3FileSystemConfig.S3SseType.CUSTOMER) {
            context.sseCustomerKey().ifPresent(s3SseCustomerKey -> builder.sseCustomerAlgorithm(s3SseCustomerKey.algorithm()).sseCustomerKey(s3SseCustomerKey.key()).sseCustomerKeyMD5(s3SseCustomerKey.md5()));
        }
    }
}

