/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.s3;

import java.util.Objects;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.Md5Utils;

public record S3SseCustomerKey(String key, String md5, String algorithm) {
    private static final String SSE_C_ALGORITHM = "AES256";

    public S3SseCustomerKey {
        Objects.requireNonNull(key, "key is null");
        Objects.requireNonNull(md5, "md5 is null");
        Objects.requireNonNull(algorithm, "algorithm is null");
    }

    public static S3SseCustomerKey onAes256(String key) {
        return new S3SseCustomerKey(key, Md5Utils.md5AsBase64((byte[])BinaryUtils.fromBase64((String)key)), SSE_C_ALGORITHM);
    }
}

