/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.local;

import com.google.common.primitives.Ints;
import io.trino.filesystem.TrinoInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

class FileTrinoInputStream
extends TrinoInputStream {
    private final RandomAccessFile input;

    public FileTrinoInputStream(File file) throws FileNotFoundException {
        this.input = new RandomAccessFile(file, "r");
    }

    @Override
    public long getPosition() throws IOException {
        return this.input.getFilePointer();
    }

    @Override
    public void seek(long position) throws IOException {
        this.input.seek(position);
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.input.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.input.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.input.skipBytes(Ints.saturatedCast((long)n));
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

