/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.local;

import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.local.FileTrinoInputStream;
import io.trino.filesystem.local.LocalInput;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;

public class LocalInputFile
implements TrinoInputFile {
    private final File file;

    public LocalInputFile(File file) {
        this.file = Objects.requireNonNull(file, "file is null");
    }

    @Override
    public TrinoInput newInput() throws IOException {
        return new LocalInput(this.file);
    }

    @Override
    public TrinoInputStream newStream() throws IOException {
        return new FileTrinoInputStream(this.file);
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public Instant lastModified() throws IOException {
        return Instant.ofEpochMilli(this.file.lastModified());
    }

    @Override
    public boolean exists() throws IOException {
        return this.file.exists();
    }

    @Override
    public String location() {
        return this.file.getPath();
    }

    public String toString() {
        return this.location();
    }
}

