/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem;

import com.google.common.base.Preconditions;

public final class Locations {
    private Locations() {
    }

    public static String appendPath(String location, String path) {
        Locations.validateLocation((String)location);
        if (!((String)location).endsWith("/")) {
            location = (String)location + "/";
        }
        return (String)location + path;
    }

    public static String getParent(String location) {
        String parent;
        Locations.validateLocation(location);
        int lastIndexOfSlash = location.lastIndexOf(47);
        if (lastIndexOfSlash > 0 && !(parent = location.substring(0, lastIndexOfSlash)).endsWith("/") && !parent.endsWith(":")) {
            return parent;
        }
        throw new IllegalArgumentException("Location does not have parent: " + location);
    }

    public static String getFileName(String location) {
        Locations.validateLocation(location);
        return location.substring(location.lastIndexOf(47) + 1);
    }

    private static void validateLocation(String location) {
        Preconditions.checkArgument((location.indexOf(63) < 0 ? 1 : 0) != 0, (String)"location contains a query string: %s", (Object)location);
        Preconditions.checkArgument((location.indexOf(35) < 0 ? 1 : 0) != 0, (String)"location contains a fragment: %s", (Object)location);
    }
}

