/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record ParsedLocation(String location, String scheme, Optional<String> userInfo, String host, String path) {
    private static final Splitter SCHEME_SPLITTER = Splitter.on((String)"://").limit(2);
    private static final Splitter QUERY_FRAGMENT_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"?#")).limit(2);
    private static final Splitter USER_INFO_SPLITTER = Splitter.on((char)'@').limit(2);
    private static final Splitter AUTHORITY_SPLITTER = Splitter.on((char)'/').limit(2);
    private static final Splitter HOST_AND_PORT_SPLITTER = Splitter.on((char)':').limit(2);

    public ParsedLocation {
        Objects.requireNonNull(scheme, "scheme is null");
        Objects.requireNonNull(userInfo, "userInfo is null");
        Objects.requireNonNull(host, "host is null");
        Objects.requireNonNull(path, "path is null");
    }

    public static ParsedLocation parseLocation(String location) {
        Objects.requireNonNull(location, "location is null");
        List schemeSplit = SCHEME_SPLITTER.splitToList((CharSequence)location);
        Preconditions.checkArgument((schemeSplit.size() == 2 ? 1 : 0) != 0, (String)"No scheme for location: %s", (Object)location);
        String scheme = (String)schemeSplit.get(0);
        String afterScheme = (String)QUERY_FRAGMENT_SPLITTER.split((CharSequence)schemeSplit.get(1)).iterator().next();
        List userInfoSplit = USER_INFO_SPLITTER.splitToList((CharSequence)afterScheme);
        Optional<String> userInfo = userInfoSplit.size() == 2 ? Optional.of((String)userInfoSplit.get(0)) : Optional.empty();
        List authoritySplit = AUTHORITY_SPLITTER.splitToList((CharSequence)Iterables.getLast((Iterable)userInfoSplit));
        String host = (String)authoritySplit.get(0);
        Preconditions.checkArgument((HOST_AND_PORT_SPLITTER.splitToStream((CharSequence)host).count() == 1L ? 1 : 0) != 0, (String)"Port is not allowed for location: %s", (Object)location);
        String path = authoritySplit.size() == 2 ? (String)authoritySplit.get(1) : "";
        return new ParsedLocation(location, scheme, userInfo, host, path);
    }

    public void verifyValidFileLocation() {
        Preconditions.checkArgument((!this.path.isEmpty() && !this.path.equals("/") ? 1 : 0) != 0, (String)"File location must contain a path: %s", (Object)this.location);
        Preconditions.checkArgument((!this.path.endsWith("/") ? 1 : 0) != 0, (String)"File location cannot end with '/': %s", (Object)this.location);
        Preconditions.checkArgument((!Character.isWhitespace(this.path.charAt(this.path.length() - 1)) ? 1 : 0) != 0, (String)"File location cannot end with whitespace: %s", (Object)this.location);
    }
}

