/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.local;

import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.local.LocalUtils;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Objects;

class LocalInput
implements TrinoInput {
    private final String location;
    private final File file;
    private final RandomAccessFile input;
    private boolean closed;

    public LocalInput(String location, File file) throws IOException {
        this.location = Objects.requireNonNull(location, "location is null");
        this.file = Objects.requireNonNull(file, "file is null");
        this.input = new RandomAccessFile(file, "r");
    }

    @Override
    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.ensureOpen();
        Objects.checkFromIndexSize(bufferOffset, bufferLength, buffer.length);
        if (position < 0L) {
            throw new IOException("Negative seek offset");
        }
        if (position >= this.file.length()) {
            throw new EOFException("Cannot read at %s. File size is %s: %s".formatted(position, this.file.length(), this.location));
        }
        try {
            this.input.seek(position);
            this.input.readFully(buffer, bufferOffset, bufferLength);
        }
        catch (IOException e) {
            throw LocalUtils.handleException(this.location, e);
        }
    }

    @Override
    public int readTail(byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.ensureOpen();
        Objects.checkFromIndexSize(bufferOffset, bufferLength, buffer.length);
        int readSize = (int)Math.min(this.file.length(), (long)bufferLength);
        this.readFully(this.file.length() - (long)readSize, buffer, bufferOffset, readSize);
        return readSize;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream closed: " + this.location);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.input.close();
    }

    public String toString() {
        return this.file.getPath();
    }
}

