/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.local;

import io.trino.filesystem.local.LocalUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

class LocalOutputStream
extends OutputStream {
    private final String location;
    private final OutputStream stream;
    private boolean closed;

    public LocalOutputStream(String location, OutputStream stream) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.stream = new BufferedOutputStream(Objects.requireNonNull(stream, "stream is null"), 4096);
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOpen();
        try {
            this.stream.write(b);
        }
        catch (IOException e) {
            throw LocalUtils.handleException(this.location, e);
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, buffer.length);
        this.ensureOpen();
        try {
            this.stream.write(buffer, offset, length);
        }
        catch (IOException e) {
            throw LocalUtils.handleException(this.location, e);
        }
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        try {
            this.stream.flush();
        }
        catch (IOException e) {
            throw LocalUtils.handleException(this.location, e);
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream closed: " + this.location);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.stream.close();
            }
            catch (IOException e) {
                throw LocalUtils.handleException(this.location, e);
            }
        }
    }
}

