/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.memory;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public class MemoryOutputStream
extends OutputStream {
    private final String location;
    private final OnStreamClose onStreamClose;
    private ByteArrayOutputStream stream = new ByteArrayOutputStream();

    public MemoryOutputStream(String location, OnStreamClose onStreamClose) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.onStreamClose = Objects.requireNonNull(onStreamClose, "onStreamClose is null");
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOpen();
        this.stream.write(b);
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        Objects.checkFromIndexSize(offset, length, buffer.length);
        this.ensureOpen();
        this.stream.write(buffer, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
    }

    private void ensureOpen() throws IOException {
        if (this.stream == null) {
            throw new IOException("Output stream closed: " + this.location);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            byte[] data = this.stream.toByteArray();
            this.stream = null;
            this.onStreamClose.onClose(Slices.wrappedBuffer((byte[])data));
        }
    }

    public static interface OnStreamClose {
        public void onClose(Slice var1) throws IOException;
    }
}

