/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.tracing;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.tracing.FileSystemAttributes;
import io.trino.filesystem.tracing.Tracing;
import io.trino.filesystem.tracing.TracingInputFile;
import io.trino.filesystem.tracing.TracingOutputFile;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;

final class TracingFileSystem
implements TrinoFileSystem {
    private final Tracer tracer;
    private final TrinoFileSystem delegate;

    public TracingFileSystem(Tracer tracer, TrinoFileSystem delegate) {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public TrinoInputFile newInputFile(String location) {
        return new TracingInputFile(this.tracer, this.delegate.newInputFile(location), Optional.empty());
    }

    @Override
    public TrinoInputFile newInputFile(String location, long length) {
        return new TracingInputFile(this.tracer, this.delegate.newInputFile(location, length), Optional.of(length));
    }

    @Override
    public TrinoOutputFile newOutputFile(String location) {
        return new TracingOutputFile(this.tracer, this.delegate.newOutputFile(location));
    }

    @Override
    public void deleteFile(String location) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystem.deleteFile").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)location).startSpan();
        Tracing.withTracing(span, () -> this.delegate.deleteFile(location));
    }

    @Override
    public void deleteFiles(Collection<String> locations) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystem.deleteFiles").setAttribute(FileSystemAttributes.FILE_LOCATION_COUNT, (Object)locations.size()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.deleteFiles(locations));
    }

    @Override
    public void deleteDirectory(String location) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystem.deleteDirectory").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)location).startSpan();
        Tracing.withTracing(span, () -> this.delegate.deleteDirectory(location));
    }

    @Override
    public void renameFile(String source, String target) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystem.renameFile").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)source).startSpan();
        Tracing.withTracing(span, () -> this.delegate.renameFile(source, target));
    }

    @Override
    public FileIterator listFiles(String location) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystem.listFiles").setAttribute(FileSystemAttributes.FILE_LOCATION, (Object)location).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.listFiles(location));
    }
}

