/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.memory;

import io.airlift.slice.Slice;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.memory.MemoryOutputStream;
import io.trino.memory.context.AggregatedMemoryContext;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.util.Objects;

class MemoryOutputFile
implements TrinoOutputFile {
    private final Location location;
    private final OutputBlob outputBlob;

    public MemoryOutputFile(Location location, OutputBlob outputBlob) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.outputBlob = Objects.requireNonNull(outputBlob, "outputBlob is null");
    }

    @Override
    public OutputStream create(AggregatedMemoryContext memoryContext) throws IOException {
        if (this.outputBlob.exists()) {
            throw new FileAlreadyExistsException(this.toString());
        }
        return new MemoryOutputStream(this.location, this.outputBlob::createBlob);
    }

    @Override
    public OutputStream createOrOverwrite(AggregatedMemoryContext memoryContext) throws IOException {
        return new MemoryOutputStream(this.location, this.outputBlob::overwriteBlob);
    }

    @Override
    public Location location() {
        return this.location;
    }

    public String toString() {
        return this.location.toString();
    }

    public static interface OutputBlob {
        public boolean exists();

        public void createBlob(Slice var1) throws FileAlreadyExistsException;

        public void overwriteBlob(Slice var1);
    }
}

