/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.memory;

import io.airlift.slice.Slice;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.memory.MemoryBlob;
import io.trino.filesystem.memory.MemoryInput;
import io.trino.filesystem.memory.MemoryInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Supplier;

public class MemoryInputFile
implements TrinoInputFile {
    private final Location location;
    private final Supplier<MemoryBlob> dataSupplier;
    private OptionalLong length;
    private Optional<Instant> lastModified = Optional.empty();

    public MemoryInputFile(Location location, Slice data) {
        this(location, () -> new MemoryBlob(data), OptionalLong.of(data.length()));
    }

    public MemoryInputFile(Location location, Supplier<MemoryBlob> dataSupplier, OptionalLong length) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.dataSupplier = Objects.requireNonNull(dataSupplier, "dataSupplier is null");
        this.length = Objects.requireNonNull(length, "length is null");
    }

    @Override
    public TrinoInput newInput() throws IOException {
        return new MemoryInput(this.location, this.getBlobRequired().data());
    }

    @Override
    public TrinoInputStream newStream() throws IOException {
        return new MemoryInputStream(this.location, this.getBlobRequired().data());
    }

    @Override
    public long length() throws IOException {
        if (this.length.isEmpty()) {
            this.length = OptionalLong.of(this.getBlobRequired().data().length());
        }
        return this.length.getAsLong();
    }

    @Override
    public Instant lastModified() throws IOException {
        if (this.lastModified.isEmpty()) {
            this.lastModified = Optional.of(this.getBlobRequired().lastModified());
        }
        return this.lastModified.get();
    }

    @Override
    public boolean exists() throws IOException {
        return this.dataSupplier.get() != null;
    }

    @Override
    public Location location() {
        return this.location;
    }

    public String toString() {
        return this.location.toString();
    }

    private MemoryBlob getBlobRequired() throws FileNotFoundException {
        MemoryBlob data = this.dataSupplier.get();
        if (data == null) {
            throw new FileNotFoundException(this.toString());
        }
        return data;
    }
}

