/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.local;

import com.google.common.base.Preconditions;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.local.LocalInput;
import io.trino.filesystem.local.LocalInputStream;
import io.trino.filesystem.local.LocalUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class LocalInputFile
implements TrinoInputFile {
    private final Location location;
    private final Path path;
    private OptionalLong length = OptionalLong.empty();
    private Optional<Instant> lastModified = Optional.empty();

    public LocalInputFile(Location location, Path path) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.path = Objects.requireNonNull(path, "path is null");
    }

    public LocalInputFile(Location location, Path path, long length) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.path = Objects.requireNonNull(path, "path is null");
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (Object)"length is negative");
        this.length = OptionalLong.of(length);
    }

    public LocalInputFile(File file) {
        this(Location.of(file.toURI().toString()), file.toPath());
    }

    @Override
    public TrinoInput newInput() throws IOException {
        try {
            return new LocalInput(this.location, this.path.toFile());
        }
        catch (IOException e) {
            throw LocalUtils.handleException(this.location, e);
        }
    }

    @Override
    public TrinoInputStream newStream() throws IOException {
        try {
            return new LocalInputStream(this.location, this.path.toFile());
        }
        catch (IOException e) {
            throw LocalUtils.handleException(this.location, e);
        }
    }

    @Override
    public long length() throws IOException {
        if (this.length.isEmpty()) {
            try {
                this.length = OptionalLong.of(Files.size(this.path));
            }
            catch (IOException e) {
                throw LocalUtils.handleException(this.location, e);
            }
        }
        return this.length.getAsLong();
    }

    @Override
    public Instant lastModified() throws IOException {
        if (this.lastModified.isEmpty()) {
            try {
                this.lastModified = Optional.of(Files.getLastModifiedTime(this.path, new LinkOption[0]).toInstant());
            }
            catch (IOException e) {
                throw LocalUtils.handleException(this.location, e);
            }
        }
        return this.lastModified.get();
    }

    @Override
    public boolean exists() throws IOException {
        return Files.exists(this.path, new LinkOption[0]);
    }

    @Override
    public Location location() {
        return this.location;
    }

    public String toString() {
        return this.location.toString();
    }
}

