/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.tracing;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.cache.TrinoFileSystemCache;
import io.trino.filesystem.tracing.CacheSystemAttributes;
import io.trino.filesystem.tracing.Tracing;
import java.io.IOException;
import java.util.Objects;

public class TracingFileSystemCache
implements TrinoFileSystemCache {
    private final Tracer tracer;
    private final TrinoFileSystemCache delegate;

    public TracingFileSystemCache(Tracer tracer, TrinoFileSystemCache delegate) {
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public TrinoInput cacheInput(TrinoInputFile delegate, String key) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystemCache.cacheInput").setAttribute(CacheSystemAttributes.CACHE_FILE_LOCATION, (Object)delegate.location().toString()).setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)key).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.cacheInput(delegate, key));
    }

    @Override
    public TrinoInputStream cacheStream(TrinoInputFile delegate, String key) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystemCache.cacheStream").setAttribute(CacheSystemAttributes.CACHE_FILE_LOCATION, (Object)delegate.location().toString()).setAttribute(CacheSystemAttributes.CACHE_KEY, (Object)key).startSpan();
        return Tracing.withTracing(span, () -> this.delegate.cacheStream(delegate, key));
    }

    @Override
    public void expire(Location location) throws IOException {
        Span span = this.tracer.spanBuilder("FileSystemCache.expire").setAttribute(CacheSystemAttributes.CACHE_FILE_LOCATION, (Object)location.toString()).startSpan();
        Tracing.withTracing(span, () -> this.delegate.expire(location));
    }
}

